/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockLightRelay
extends BlockMod
implements IWandable,
ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);

    protected BlockLightRelay() {
        super(Material.field_151592_s, "lightRelay");
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.LUMINIZER_VARIANT, BotaniaStateProps.POWERED});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.LUMINIZER_VARIANT, (Comparable)((Object)LuminizerVariant.DEFAULT)).func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        int meta;
        int n = meta = state.func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.DETECTOR ? 1 : 0;
        meta = ((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED)).booleanValue() ? (meta |= 8) : (meta &= 0xFFFFFFF7);
        return meta;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        boolean powered = (meta & 8) != 0;
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a(BotaniaStateProps.LUMINIZER_VARIANT, (Comparable)((Object)((meta &= 0xFFFFFFF7) == 1 ? LuminizerVariant.DETECTOR : LuminizerVariant.DEFAULT)));
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockWithMetadataAndName(this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.DEFAULT ? 0 : 1;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing s, float xs, float ys, float zs) {
        ((TileLightRelay)world.func_175625_s(pos)).mountEntity((Entity)player);
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return null;
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing s) {
        return state.func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.DETECTOR && (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 15 : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileLightRelay();
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.luminizerTransport;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        int i = 0;
        for (LuminizerVariant v : LuminizerVariant.values()) {
            ModelHandler.registerBlockToState(this, i++, this.func_176223_P().func_177226_a(BotaniaStateProps.LUMINIZER_VARIANT, (Comparable)((Object)v)));
        }
    }
}

