/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.item.block.ItemBlockPool;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPool
extends BlockMod
implements IWandHUD,
IWandable,
ILexiconable,
ICraftAchievement {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private boolean lastFragile = false;
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.0625);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 0.5, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockPool() {
        super(Material.field_151576_e, "pool");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        BotaniaAPI.blacklistBlockFromMagnet(this, Short.MAX_VALUE);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.POOL_VARIANT, BotaniaStateProps.COLOR});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.POOL_VARIANT, (Comparable)((Object)PoolVariant.DEFAULT)).func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE);
    }

    public int func_176201_c(IBlockState state) {
        return ((PoolVariant)((Object)state.func_177229_b(BotaniaStateProps.POOL_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta > PoolVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.POOL_VARIANT, (Comparable)((Object)PoolVariant.values()[meta]));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePool) {
            return state.func_177226_a(BotaniaStateProps.COLOR, (Comparable)((TilePool)te).color);
        }
        return state.func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockPool(this), (ResourceLocation)this.getRegistryName());
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TilePool pool = (TilePool)world.func_175625_s(pos);
        this.lastFragile = pool.fragile;
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!this.lastFragile) {
            drops.add(new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state)));
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs par2, List<ItemStack> par3) {
        par3.add(new ItemStack(item, 1, 0));
        par3.add(new ItemStack(item, 1, 2));
        par3.add(new ItemStack(item, 1, 3));
        par3.add(new ItemStack(item, 1, 1));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePool();
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity par5Entity) {
        TilePool tile;
        if (par5Entity instanceof EntityItem && (tile = (TilePool)world.func_175625_s(pos)).collideEntityItem((EntityItem)par5Entity)) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(world, pos);
        }
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> boxes, Entity entity) {
        BlockPool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, boxes, (AxisAlignedBB)BOTTOM_AABB);
        BlockPool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, boxes, (AxisAlignedBB)NORTH_AABB);
        BlockPool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, boxes, (AxisAlignedBB)SOUTH_AABB);
        BlockPool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, boxes, (AxisAlignedBB)WEST_AABB);
        BlockPool.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, boxes, (AxisAlignedBB)EAST_AABB);
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS) {
            return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TilePool pool = (TilePool)world.func_175625_s(pos);
        int val = (int)((double)pool.getCurrentMana() / (double)pool.manaCap * 15.0);
        if (pool.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TilePool)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TilePool)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return world.func_180495_p(pos).func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS ? LexiconData.rainbowRod : LexiconData.pool;
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.manaPoolPickup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.COLOR}).func_178441_a());
        ModelHandler.registerBlockToState(this, PoolVariant.values().length);
    }
}

