/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockSpreader
extends BlockMod
implements IWandable,
IWandHUD,
ILexiconable,
IWireframeAABBProvider {
    public BlockSpreader() {
        super(Material.field_151575_d, "spreader");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.SPREADER_VARIANT});
    }

    @Override
    protected IBlockState pickDefaultState() {
        return this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.SPREADER_VARIANT, (Comparable)((Object)SpreaderVariant.MANA));
    }

    public int func_176201_c(IBlockState state) {
        return ((SpreaderVariant)((Object)state.func_177229_b(BotaniaStateProps.SPREADER_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta > SpreaderVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.SPREADER_VARIANT, (Comparable)((Object)SpreaderVariant.values()[meta]));
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockWithMetadataAndName(this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs par2, List<ItemStack> par3) {
        for (int i = 0; i < 4; ++i) {
            par3.add(new ItemStack(item, 1, i));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        EnumFacing orientation = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)par5EntityLivingBase);
        TileSpreader spreader = (TileSpreader)world.func_175625_s(pos);
        world.func_180501_a(pos, this.func_176203_a(par6ItemStack.func_77952_i()), 3);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            default: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    public int func_180651_a(IBlockState par1) {
        return this.func_176201_c(par1);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing par6, float par7, float par8, float par9) {
        boolean wool;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileSpreader)) {
            return false;
        }
        TileSpreader spreader = (TileSpreader)tile;
        ItemStack lens = spreader.getItemHandler().getStackInSlot(0);
        boolean isHeldItemLens = heldItem != null && heldItem.func_77973_b() instanceof ILens;
        boolean bl = wool = heldItem != null && heldItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L);
        if (heldItem != null && heldItem.func_77973_b() == ModItems.twigWand) {
            return false;
        }
        if (lens == null && isHeldItemLens) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, null);
            }
            spreader.getItemHandler().setStackInSlot(0, heldItem.func_77946_l());
            spreader.func_70296_d();
        } else if (lens != null && !wool) {
            ItemStack add = lens.func_77946_l();
            if (!player.field_71071_by.func_70441_a(add)) {
                player.func_71019_a(add, false);
            }
            spreader.getItemHandler().setStackInSlot(0, null);
            spreader.func_70296_d();
        }
        if (wool && spreader.paddingColor == -1) {
            spreader.paddingColor = heldItem.func_77952_i();
            --heldItem.field_77994_a;
            if (heldItem.field_77994_a == 0) {
                player.func_184611_a(hand, null);
            }
        } else if (heldItem == null && spreader.paddingColor != -1 && lens == null) {
            ItemStack pad = new ItemStack(Blocks.field_150325_L, 1, spreader.paddingColor);
            if (!player.field_71071_by.func_70441_a(pad)) {
                player.func_71019_a(pad, false);
            }
            spreader.paddingColor = -1;
            spreader.func_70296_d();
        }
        return true;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileSpreader)) {
            return;
        }
        TileSpreader inv = (TileSpreader)tile;
        if (inv.paddingColor != -1) {
            net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(Blocks.field_150325_L, 1, inv.paddingColor));
        }
        InventoryHelper.dropInventory(inv, world, state, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TileSpreader)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileSpreader();
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpreader)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        SpreaderVariant variant = (SpreaderVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.SPREADER_VARIANT));
        return variant == SpreaderVariant.MANA ? LexiconData.spreader : (variant == SpreaderVariant.REDSTONE ? LexiconData.redstoneSpreader : LexiconData.dreamwoodSpreader);
    }

    @Override
    public AxisAlignedBB getWireframeAABB(World world, BlockPos pos) {
        return field_185505_j.func_186670_a(pos).func_186664_h(0.0625);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, SpreaderVariant.values().length);
    }
}

