/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.core.handler.MethodHandles;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileGourmaryllis
extends SubTileGenerating {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int RANGE = 1;
    int cooldown = 0;
    int storedMana = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.cooldown == 0) {
            this.mana = Math.min(this.getMaxMana(), this.mana + this.storedMana);
            this.storedMana = 0;
            this.sync();
        }
        int slowdown = this.getSlowdownFactor();
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-1, -1, -1), this.supertile.func_174877_v().func_177982_a(2, 2, 2)));
        for (EntityItem item : items) {
            int age;
            ItemStack stack = item.func_92059_d();
            try {
                age = MethodHandles.itemAge_getter.invokeExact(item);
            }
            catch (Throwable t) {
                continue;
            }
            if (stack == null || !(stack.func_77973_b() instanceof ItemFood) || item.field_70128_L || age < slowdown) continue;
            if (this.cooldown <= 0) {
                int val = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
                this.storedMana = val * val * 64;
                this.cooldown = val * 10;
                item.func_184185_a(SoundEvents.field_187537_bA, 0.2f, 0.5f + (float)Math.random() * 0.5f);
                this.sync();
                ((WorldServer)this.supertile.func_145831_w()).func_180505_a(EnumParticleTypes.ITEM_CRACK, false, item.field_70165_t, item.field_70163_u, item.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77952_i()});
            }
            item.func_70106_y();
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 8000;
    }

    @Override
    public int getColor() {
        return 13882884;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.gourmaryllis;
    }
}

