/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.ILexicon;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.recipe.ElvenPortalUpdateEvent;
import vazkii.botania.api.recipe.IElvenItem;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.LivingWoodVariant;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.lexicon.LexiconData;

public class TileAlfPortal
extends TileMod {
    private static final BlockPos[] LIVINGWOOD_POSITIONS;
    private static final BlockPos[] GLIMMERING_LIVINGWOOD_POSITIONS;
    private static final BlockPos[] AIR_POSITIONS;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    private static final String TAG_PORTAL_FLAG = "_elvenPortal";
    private final List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private static final Function<BlockPos, BlockPos> CONVERTER_X_Z;
    private static final Function<double[], double[]> CONVERTER_X_Z_FP;
    private static final Function<BlockPos, BlockPos> CONVERTER_Z_SWAP;

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos l : LIVINGWOOD_POSITIONS) {
            mb.addComponent(l.func_177984_a(), ModBlocks.livingwood.func_176223_P());
        }
        for (BlockPos g : GLIMMERING_LIVINGWOOD_POSITIONS) {
            mb.addComponent(g.func_177984_a(), ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.GLIMMERING)));
        }
        mb.addComponent(new BlockPos(0, 1, 0), ModBlocks.alfPortal.func_176223_P());
        mb.setRenderOffset(new BlockPos(0, -1, 0));
        return mb.makeSet();
    }

    @Override
    public void func_73660_a() {
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iBlockState.func_177229_b(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.OFF) {
            this.ticksOpen = 0;
            return;
        }
        AlfPortalState state = (AlfPortalState)((Object)iBlockState.func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        AlfPortalState newState = this.getValidState();
        ++this.ticksOpen;
        AxisAlignedBB aabb = this.getPortalAABB();
        boolean open = this.ticksOpen > 60;
        ElvenPortalUpdateEvent event = new ElvenPortalUpdateEvent(this, aabb, open, this.stacksIn);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (this.ticksOpen > 60) {
            ++this.ticksSinceLastItem;
            if (ConfigHandler.elfPortalParticlesEnabled) {
                this.blockParticle(state);
            }
            List items = this.field_145850_b.func_72872_a(EntityItem.class, aabb);
            if (!this.field_145850_b.field_72995_K) {
                for (EntityItem item : items) {
                    ItemStack stack;
                    if (item.field_70128_L || (stack = item.func_92059_d()).func_77973_b() instanceof IElvenItem && ((IElvenItem)stack.func_77973_b()).isElvenItem(stack) || item.getEntityData().func_74764_b(TAG_PORTAL_FLAG)) continue;
                    item.func_70106_y();
                    this.addItem(stack);
                    this.ticksSinceLastItem = 0;
                }
            }
            if (this.ticksSinceLastItem >= 4 && !this.field_145850_b.field_72995_K) {
                this.resolveRecipes();
            }
        }
        if (this.closeNow) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), ModBlocks.alfPortal.func_176223_P(), 3);
            for (int i = 0; i < 36; ++i) {
                this.blockParticle(state);
            }
            this.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    this.blockParticle(state);
                }
            }
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)), 3);
        }
    }

    private void blockParticle(AlfPortalState state) {
        int i = this.field_145850_b.field_73012_v.nextInt(AIR_POSITIONS.length);
        double[] pos = new double[]{(float)AIR_POSITIONS[i].func_177958_n() + 0.5f, (float)AIR_POSITIONS[i].func_177956_o() + 0.5f, (float)AIR_POSITIONS[i].func_177952_p() + 0.5f};
        if (state == AlfPortalState.ON_X) {
            pos = CONVERTER_X_Z_FP.apply(pos);
        }
        float motionMul = 0.2f;
        Botania.proxy.wispFX((double)this.func_174877_v().func_177958_n() + pos[0], (double)this.func_174877_v().func_177956_o() + pos[1], (double)this.func_174877_v().func_177952_p() + pos[2], (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25), (float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() - 0.5) * motionMul, (float)(Math.random() - 0.5) * motionMul, (float)(Math.random() - 0.5) * motionMul);
    }

    public boolean onWanded() {
        AlfPortalState newState;
        AlfPortalState state = (AlfPortalState)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.ALFPORTAL_STATE));
        if (state == AlfPortalState.OFF && (newState = this.getValidState()) != AlfPortalState.OFF) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)newState)), 3);
            return true;
        }
        return false;
    }

    private AxisAlignedBB getPortalAABB() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 1, 0), this.field_174879_c.func_177982_a(2, 4, 1));
        if (this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.ALFPORTAL_STATE) == AlfPortalState.ON_X) {
            aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, -1), this.field_174879_c.func_177982_a(1, 4, 2));
        }
        return aabb;
    }

    private void addItem(ItemStack stack) {
        int size = stack.field_77994_a;
        stack.field_77994_a = 1;
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.func_77946_l());
        }
    }

    private void resolveRecipes() {
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            if (stack != null && stack.func_77973_b() instanceof ILexicon) {
                ((ILexicon)stack.func_77973_b()).unlockKnowledge(stack, BotaniaAPI.elvenKnowledge);
                ItemLexicon.setForcedPage(stack, LexiconData.elvenMessage.getUnlocalizedName());
                this.spawnItem(stack);
                this.stacksIn.remove(i);
                return;
            }
            ++i;
        }
        for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
            if (!recipe.matches(this.stacksIn, false)) continue;
            if (!this.consumeMana(null, 500, false)) break;
            recipe.matches(this.stacksIn, true);
            for (ItemStack output : recipe.getOutputs()) {
                this.spawnItem(output.func_77946_l());
            }
        }
    }

    private void spawnItem(ItemStack stack) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        item.getEntityData().func_74757_a(TAG_PORTAL_FLAG, true);
        this.field_145850_b.func_72838_d((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound cmp) {
        NBTTagCompound ret = super.func_189515_b(cmp);
        cmp.func_74768_a(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            NBTTagCompound stackcmp = new NBTTagCompound();
            stack.func_77955_b(stackcmp);
            cmp.func_74782_a(TAG_STACK + i, (NBTBase)stackcmp);
            ++i;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound cmp) {
        super.func_145839_a(cmp);
        int count = cmp.func_74762_e(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound stackcmp = cmp.func_74775_l(TAG_STACK + i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.func_74768_a(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.ticksOpen = cmp.func_74762_e(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.func_74762_e(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private AlfPortalState getValidState() {
        if (this.checkConverter(null)) {
            return AlfPortalState.ON_Z;
        }
        if (this.checkConverter(CONVERTER_X_Z)) {
            return AlfPortalState.ON_X;
        }
        return AlfPortalState.OFF;
    }

    private boolean checkConverter(Function<BlockPos, BlockPos> baseConverter) {
        return this.checkMultipleConverters(baseConverter) || this.checkMultipleConverters(CONVERTER_Z_SWAP, baseConverter);
    }

    @SafeVarargs
    private final boolean checkMultipleConverters(Function<BlockPos, BlockPos> ... converters) {
        if (!this.check2DArray(AIR_POSITIONS, Blocks.field_150350_a.func_176223_P(), true, converters)) {
            return false;
        }
        if (!this.check2DArray(LIVINGWOOD_POSITIONS, ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.DEFAULT)), false, converters)) {
            return false;
        }
        if (!this.check2DArray(GLIMMERING_LIVINGWOOD_POSITIONS, ModBlocks.livingwood.func_176223_P().func_177226_a(BotaniaStateProps.LIVINGWOOD_VARIANT, (Comparable)((Object)LivingWoodVariant.GLIMMERING)), false, converters)) {
            return false;
        }
        this.lightPylons();
        return true;
    }

    public List<BlockPos> locatePylons() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int range = 5;
        IBlockState pylonState = ModBlocks.pylon.func_176223_P().func_177226_a(BotaniaStateProps.PYLON_VARIANT, (Comparable)((Object)PylonVariant.NATURA));
        IBlockState poolState = ModBlocks.pool.func_176223_P();
        for (int i = -range; i < range + 1; ++i) {
            for (int j = -range; j < range + 1; ++j) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!this.checkPosition(pos, pylonState, false) || !this.checkPosition(pos.func_177977_b(), poolState, true)) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        List<BlockPos> pylons = this.locatePylons();
        for (BlockPos pos : pylons) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos));
            if (!(tile instanceof TilePylon)) continue;
            TilePylon pylon = (TilePylon)tile;
            pylon.activated = true;
            pylon.centerPos = this.func_174877_v();
        }
        if (this.ticksOpen == 50) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(@Nullable List<BlockPos> pylons, int totalCost, boolean close) {
        ArrayList<TilePool> consumePools = new ArrayList<TilePool>();
        int consumed = 0;
        if (pylons == null) {
            pylons = this.locatePylons();
        }
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (BlockPos pos : pylons) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos));
            if (tile instanceof TilePylon) {
                TilePylon pylon = (TilePylon)tile;
                pylon.activated = true;
                pylon.centerPos = this.func_174877_v();
            }
            if (!((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos).func_177977_b())) instanceof TilePool)) continue;
            TilePool pool = (TilePool)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.field_145850_b.field_72995_K) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (TilePool pool : consumePools) {
                pool.recieveMana(-costPer);
            }
            return true;
        }
        return false;
    }

    @SafeVarargs
    private final boolean check2DArray(BlockPos[] positions, IBlockState state, boolean onlyCheckBlock, Function<BlockPos, BlockPos> ... converters) {
        for (BlockPos pos : positions) {
            for (Function<BlockPos, BlockPos> f : converters) {
                if (f == null) continue;
                pos = f.apply(pos);
            }
            if (this.checkPosition(pos, state, onlyCheckBlock)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPosition(BlockPos pos, IBlockState state, boolean onlyCheckBlock) {
        BlockPos pos_ = this.func_174877_v().func_177971_a((Vec3i)pos);
        IBlockState stateat = this.field_145850_b.func_180495_p(pos_);
        Block blockat = stateat.func_177230_c();
        if (state.func_177230_c() == Blocks.field_150350_a ? blockat.isAir(stateat, (IBlockAccess)this.field_145850_b, pos_) : blockat == state.func_177230_c()) {
            return onlyCheckBlock || stateat == state;
        }
        return false;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private static /* synthetic */ BlockPos lambda$static$2(BlockPos input) {
        return new BlockPos(input.func_177958_n(), input.func_177956_o(), -input.func_177952_p());
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

