/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import baubles.common.lib.PlayerHandler;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSyncBauble;
import buildcraft.api.transport.IPipeTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.api.internal.DummyMethodHandler;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.integration.corporea.WrappedDeepStorage;
import vazkii.botania.common.integration.corporea.WrappedIInventory;
import vazkii.botania.common.integration.corporea.WrappedStorageDrawers;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.lexicon.page.PageBrew;
import vazkii.botania.common.lexicon.page.PageCraftingRecipe;
import vazkii.botania.common.lexicon.page.PageElvenRecipe;
import vazkii.botania.common.lexicon.page.PageImage;
import vazkii.botania.common.lexicon.page.PageLoreText;
import vazkii.botania.common.lexicon.page.PageManaInfusionRecipe;
import vazkii.botania.common.lexicon.page.PageMultiblock;
import vazkii.botania.common.lexicon.page.PagePetalRecipe;
import vazkii.botania.common.lexicon.page.PageRuneRecipe;
import vazkii.botania.common.lexicon.page.PageText;

public class InternalMethodHandler
extends DummyMethodHandler {
    @Override
    public LexiconPage textPage(String key) {
        return new PageText(key);
    }

    @Override
    public LexiconPage elfPaperTextPage(String key) {
        return new PageLoreText(key);
    }

    @Override
    public LexiconPage imagePage(String key, String resource) {
        return new PageImage(key, resource);
    }

    @Override
    public LexiconPage craftingRecipesPage(String key, List<IRecipe> recipes) {
        return new PageCraftingRecipe(key, recipes);
    }

    @Override
    public LexiconPage craftingRecipePage(String key, IRecipe recipe) {
        return new PageCraftingRecipe(key, recipe);
    }

    @Override
    public ModelResourceLocation getSubTileBlockModelForName(String name) {
        return BotaniaAPIClient.getRegisteredSubtileBlockModels().get(name);
    }

    @Override
    public ModelResourceLocation getSubTileItemModelForName(String name) {
        return BotaniaAPIClient.getRegisteredSubtileItemModels().get(name);
    }

    @Override
    public LexiconPage petalRecipesPage(String key, List<RecipePetals> recipes) {
        return new PagePetalRecipe<List<RecipePetals>>(key, recipes);
    }

    @Override
    public LexiconPage petalRecipePage(String key, RecipePetals recipe) {
        return new PagePetalRecipe<RecipePetals>(key, recipe);
    }

    @Override
    public LexiconPage runeRecipesPage(String key, List<RecipeRuneAltar> recipes) {
        return new PageRuneRecipe(key, recipes);
    }

    @Override
    public LexiconPage runeRecipePage(String key, RecipeRuneAltar recipe) {
        return new PageRuneRecipe(key, recipe);
    }

    @Override
    public LexiconPage manaInfusionRecipesPage(String key, List<RecipeManaInfusion> recipes) {
        return new PageManaInfusionRecipe(key, recipes);
    }

    @Override
    public LexiconPage manaInfusionRecipePage(String key, RecipeManaInfusion recipe) {
        return new PageManaInfusionRecipe(key, recipe);
    }

    @Override
    public LexiconPage elvenTradePage(String key, List<RecipeElvenTrade> recipes) {
        return new PageElvenRecipe(key, recipes);
    }

    @Override
    public LexiconPage elvenTradesPage(String key, RecipeElvenTrade recipe) {
        return new PageElvenRecipe(key, recipe);
    }

    @Override
    public LexiconPage brewPage(String key, String bottomText, RecipeBrew recipe) {
        return new PageBrew(recipe, key, bottomText);
    }

    @Override
    public LexiconPage multiblockPage(String key, MultiblockSet mb) {
        return new PageMultiblock(key, mb);
    }

    @Override
    public ItemStack getSubTileAsStack(String subTile) {
        return ItemBlockSpecialFlower.ofType(subTile);
    }

    @Override
    public ItemStack getSubTileAsFloatingFlowerStack(String subTile) {
        return ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.floatingSpecialFlower), subTile);
    }

    @Override
    public String getStackSubTileKey(ItemStack stack) {
        return ItemBlockSpecialFlower.getType(stack);
    }

    @Override
    public IManaNetwork getManaNetworkInstance() {
        return ManaNetworkHandler.instance;
    }

    @Override
    public IInventory getBaublesInventory(EntityPlayer player) {
        return PlayerHandler.getPlayerBaubles((EntityPlayer)player);
    }

    @Override
    public IItemHandlerModifiable getBaublesInventoryWrapped(EntityPlayer player) {
        IInventory inv = this.getBaublesInventory(player);
        return inv == null ? null : new InvWrapper(inv);
    }

    @Override
    public void drawSimpleManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res) {
        HUDHandler.drawSimpleManaHUD(color, mana, maxMana, name, res);
    }

    @Override
    public void drawComplexManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res, ItemStack bindDisplay, boolean properlyBound) {
        HUDHandler.drawComplexManaHUD(color, mana, maxMana, name, res, bindDisplay, properlyBound);
    }

    @Override
    public ItemStack getBindDisplayForFlowerType(SubTileEntity e) {
        return e instanceof SubTileGenerating ? new ItemStack(ModBlocks.spreader) : (e instanceof SubTileFunctional ? new ItemStack(ModBlocks.pool) : new ItemStack(ModItems.twigWand));
    }

    @Override
    public void renderLexiconText(int x, int y, int width, int height, String unlocalizedText) {
        PageText.renderText(x, y, width, height, unlocalizedText);
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m) {
        Botania.proxy.sparkleFX(x, y, z, r, g, b, size, m);
    }

    @Override
    public ResourceLocation getDefaultBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @Override
    public boolean shouldForceCheck() {
        return ConfigHandler.flowerForceCheck;
    }

    @Override
    public int getPassiveFlowerDecay() {
        return 72000;
    }

    @Override
    @Optional.Method(modid="BuildCraft|Transport")
    public boolean isBuildcraftPipe(TileEntity tile) {
        return tile instanceof IPipeTile;
    }

    @Override
    public void breakOnAllCursors(EntityPlayer player, Item item, ItemStack stack, BlockPos pos, EnumFacing side) {
        ItemLokiRing.breakOnAllCursors(player, item, stack, pos, side);
    }

    @Override
    public boolean hasSolegnoliaAround(Entity e) {
        return SubTileSolegnolia.hasSolegnoliaAround(e);
    }

    @Override
    public long getWorldElapsedTicks() {
        return Botania.proxy.getWorldElapsedTicks();
    }

    @Override
    public boolean isBotaniaFlower(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == ModBlocks.flower || block == ModBlocks.shinyFlower || block == ModBlocks.specialFlower;
    }

    @Override
    public void sendBaubleUpdatePacket(EntityPlayer player, int slot) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, slot), (EntityPlayerMP)player);
        }
    }

    @Override
    public List<IWrappedInventory> wrapInventory(List<InvWithLocation> inventories) {
        ArrayList<IWrappedInventory> arrayList = new ArrayList<IWrappedInventory>();
        for (InvWithLocation inv : inventories) {
            ICorporeaSpark spark = CorporeaHelper.getSparkForInventory(inv);
            IWrappedInventory wrapped = null;
            if (Botania.storageDrawersLoaded) {
                wrapped = WrappedStorageDrawers.wrap(inv, spark);
            }
            if (wrapped == null) {
                wrapped = WrappedDeepStorage.wrap(inv, spark);
            }
            if (wrapped == null) {
                wrapped = WrappedIInventory.wrap(inv, spark);
            }
            arrayList.add(wrapped);
        }
        return arrayList;
    }
}

