/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;

public final class PixieHandler {
    private static final Potion[] potions = new Potion[]{MobEffects.field_76440_q, MobEffects.field_82731_v, MobEffects.field_76421_d, MobEffects.field_76437_t};

    private PixieHandler() {
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = PlayerHelper.getFirstHeldItemClass(player, IPixieSpawner.class);
            float chance = PixieHandler.getChance(stack);
            for (ItemStack element : player.field_71071_by.field_70460_b) {
                chance += PixieHandler.getChance(element);
            }
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                chance += PixieHandler.getChance(baubles.func_70301_a(i));
            }
            if (Math.random() < (double)chance) {
                EntityPixie pixie = new EntityPixie(player.field_70170_p);
                pixie.func_70107_b(player.field_70165_t, player.field_70163_u + 2.0, player.field_70161_v);
                if (((ItemElementiumHelm)ModItems.elementiumHelm).hasArmorSet(player)) {
                    pixie.setApplyPotionEffect(new PotionEffect(potions[event.getEntityLiving().field_70170_p.field_73012_v.nextInt(potions.length)], 40, 0));
                }
                float dmg = 4.0f;
                if (stack != null && stack.func_77973_b() == ModItems.elementiumSword) {
                    dmg += 2.0f;
                }
                pixie.setProps((EntityLivingBase)event.getSource().func_76346_g(), (EntityLivingBase)player, 0, dmg);
                player.field_70170_p.func_72838_d((Entity)pixie);
            }
        }
    }

    private static float getChance(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof IPixieSpawner)) {
            return 0.0f;
        }
        return ((IPixieSpawner)stack.func_77973_b()).getPixieChance(stack);
    }
}

