/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.botania.client.core.handler.ClientMethodHandles;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.gui.crafting.InventoryCraftingHalo;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemMod;

public class ItemCraftingHalo
extends ItemMod
implements ICraftAchievement {
    private static final ResourceLocation glowTexture = new ResourceLocation("botania:textures/misc/glow0.png");
    private static final ItemStack craftingTable = new ItemStack(Blocks.field_150462_ai);
    public static final int SEGMENTS = 12;
    private static final String TAG_LAST_CRAFTING = "lastCrafting";
    private static final String TAG_STORED_RECIPE_PREFIX = "storedRecipe";
    private static final String TAG_ITEM_PREFIX = "item";
    private static final String TAG_EQUIPPED = "equipped";
    private static final String TAG_ROTATION_BASE = "rotationBase";

    public ItemCraftingHalo() {
        this("craftingHalo");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemCraftingHalo(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        int segment = ItemCraftingHalo.getSegmentLookedAt(stack, (EntityLivingBase)player);
        ItemStack itemForPos = ItemCraftingHalo.getItemForSlot(stack, segment);
        if (segment == 0) {
            player.openGui((Object)Botania.instance, 1, world, hand == EnumHand.OFF_HAND ? 1 : 0, 0, 0);
        } else if (itemForPos == null) {
            ItemCraftingHalo.assignRecipe(stack, itemForPos, segment);
        } else {
            this.tryCraft(player, stack, segment, true, ItemCraftingHalo.getFakeInv(player), true);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static IItemHandler getFakeInv(EntityPlayer player) {
        ItemStackHandler ret = new ItemStackHandler(player.field_71071_by.field_70462_a.length);
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            ret.setStackInSlot(i, player.field_71071_by.field_70462_a[i].func_77946_l());
        }
        return ret;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase living = (EntityLivingBase)entity;
        boolean eqLastTick = ItemCraftingHalo.wasEquipped(stack);
        if (!equipped && living.func_184592_cb() == stack) {
            equipped = true;
        }
        if (eqLastTick != equipped) {
            ItemCraftingHalo.setEquipped(stack, equipped);
        }
        if (!equipped) {
            int angles = 360;
            int segAngles = angles / 12;
            float shift = segAngles / 2;
            ItemCraftingHalo.setRotationBase(stack, ItemCraftingHalo.getCheckingAngle((EntityLivingBase)entity) - shift);
        }
    }

    void tryCraft(EntityPlayer player, ItemStack stack, int slot, boolean particles, IItemHandler inv, boolean validate) {
        ItemStack itemForPos = ItemCraftingHalo.getItemForSlot(stack, slot);
        if (itemForPos == null) {
            return;
        }
        ItemStack[] recipe = ItemCraftingHalo.getCraftingItems(stack, slot);
        if (validate) {
            recipe = ItemCraftingHalo.validateRecipe(player, stack, recipe, slot);
        }
        if (ItemCraftingHalo.canCraft(recipe, inv)) {
            ItemCraftingHalo.doCraft(player, recipe, particles);
        }
    }

    private static ItemStack[] validateRecipe(EntityPlayer player, ItemStack stack, ItemStack[] recipe, int slot) {
        InventoryCrafting fakeInv = new InventoryCrafting((Container)new ContainerWorkbench(player.field_71071_by, player.field_70170_p, BlockPos.field_177992_a), 3, 3);
        for (int i = 0; i < 9; ++i) {
            fakeInv.func_70299_a(i, recipe[i]);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(fakeInv, player.field_70170_p);
        if (result == null) {
            ItemCraftingHalo.assignRecipe(stack, recipe[9], slot);
            return null;
        }
        if (!result.func_77969_a(recipe[9]) || result.field_77994_a != recipe[9].field_77994_a || !ItemStack.func_77970_a((ItemStack)recipe[9], (ItemStack)result)) {
            ItemCraftingHalo.assignRecipe(stack, recipe[9], slot);
            return null;
        }
        return recipe;
    }

    private static boolean canCraft(ItemStack[] recipe, IItemHandler inv) {
        if (recipe == null) {
            return false;
        }
        if (ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)recipe[9], (boolean)true) != null) {
            return false;
        }
        return ItemCraftingHalo.consumeRecipeIngredients(recipe, inv, null);
    }

    private static void doCraft(EntityPlayer player, ItemStack[] recipe, boolean particles) {
        ItemCraftingHalo.consumeRecipeIngredients(recipe, (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP), player);
        if (!player.field_71071_by.func_70441_a(recipe[9])) {
            player.func_71019_a(recipe[9], false);
        }
        if (!particles) {
            return;
        }
        Vec3d lookVec3 = player.func_70040_Z();
        Vector3 centerVector = Vector3.fromEntityCenter((Entity)player).add(lookVec3.field_72450_a * 3.0, 1.3, lookVec3.field_72449_c * 3.0);
        float m = 0.1f;
        for (int i = 0; i < 4; ++i) {
            Botania.proxy.wispFX(centerVector.x, centerVector.y, centerVector.z, 1.0f, 0.0f, 1.0f, 0.2f + 0.2f * (float)Math.random(), ((float)Math.random() - 0.5f) * m, ((float)Math.random() - 0.5f) * m, ((float)Math.random() - 0.5f) * m);
        }
    }

    private static boolean consumeRecipeIngredients(ItemStack[] recipe, IItemHandler inv, EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = recipe[i];
            if (ingredient == null || ItemCraftingHalo.consumeFromInventory(ingredient, inv, player)) continue;
            return false;
        }
        return true;
    }

    private static boolean consumeFromInventory(ItemStack stack, IItemHandler inv, EntityPlayer player) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stackAt = inv.getStackInSlot(i);
            if (stackAt == null || !stack.func_77969_a(stackAt) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackAt)) continue;
            boolean consume = true;
            ItemStack container = stackAt.func_77973_b().getContainerItem(stackAt);
            if (container != null) {
                if (container == stackAt) {
                    consume = false;
                } else if (player == null) {
                    ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)container, (boolean)false);
                } else {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)container);
                }
            }
            if (consume) {
                inv.extractItem(i, 1, false);
            }
            return true;
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase player, ItemStack stack) {
        int segment = ItemCraftingHalo.getSegmentLookedAt(stack, player);
        if (segment == 0) {
            return false;
        }
        ItemStack itemForPos = ItemCraftingHalo.getItemForSlot(stack, segment);
        if (itemForPos != null && player.func_70093_af()) {
            ItemCraftingHalo.assignRecipe(stack, itemForPos, segment);
            return true;
        }
        return false;
    }

    private static int getSegmentLookedAt(ItemStack stack, EntityLivingBase player) {
        ItemCraftingHalo.getRotationBase(stack);
        float yaw = ItemCraftingHalo.getCheckingAngle(player, ItemCraftingHalo.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 12; ++seg) {
            float calcAngle = (float)seg * (float)segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    private static float getCheckingAngle(EntityLivingBase player) {
        return ItemCraftingHalo.getCheckingAngle(player, 0.0f);
    }

    private static float getCheckingAngle(EntityLivingBase player, float base) {
        float angle;
        float yaw = MathHelper.func_76142_g((float)player.field_70177_z) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = segAngles / 2;
        if (yaw < 0.0f) {
            yaw = 180.0f + (180.0f + yaw);
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) < 0.0f) {
            angle = 360.0f + angle;
        }
        return angle;
    }

    public static ItemStack getItemForSlot(ItemStack stack, int slot) {
        if (slot == 0) {
            return craftingTable;
        }
        if (slot >= 12) {
            return null;
        }
        NBTTagCompound cmp = ItemCraftingHalo.getStoredRecipeCompound(stack, slot);
        if (cmp != null) {
            ItemStack cmpStack = ItemCraftingHalo.getLastCraftingItem(cmp, 9);
            return cmpStack;
        }
        return null;
    }

    public static void assignRecipe(ItemStack stack, ItemStack itemForPos, int pos) {
        if (itemForPos != null) {
            ItemNBTHelper.setCompound(stack, TAG_STORED_RECIPE_PREFIX + pos, new NBTTagCompound());
        } else {
            ItemNBTHelper.setCompound(stack, TAG_STORED_RECIPE_PREFIX + pos, ItemCraftingHalo.getLastCraftingCompound(stack, false));
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (!(event.craftMatrix instanceof InventoryCraftingHalo)) {
            return;
        }
        for (int i = 0; i < event.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = event.player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemCraftingHalo)) continue;
            this.saveRecipeToStack(event, stack);
        }
    }

    private void saveRecipeToStack(PlayerEvent.ItemCraftedEvent event, ItemStack stack) {
        NBTTagCompound cmp = new NBTTagCompound();
        NBTTagCompound cmp1 = new NBTTagCompound();
        ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)event.craftMatrix, event.player.field_70170_p);
        if (result != null) {
            result.func_77955_b(cmp1);
            cmp.func_74782_a("item9", (NBTBase)cmp1);
            for (int i = 0; i < 9; ++i) {
                cmp1 = new NBTTagCompound();
                ItemStack stackSlot = event.craftMatrix.func_70301_a(i);
                if (stackSlot != null) {
                    ItemStack writeStack = stackSlot.func_77946_l();
                    writeStack.field_77994_a = 1;
                    writeStack.func_77955_b(cmp1);
                }
                cmp.func_74782_a(TAG_ITEM_PREFIX + i, (NBTBase)cmp1);
            }
        }
        ItemNBTHelper.setCompound(stack, TAG_LAST_CRAFTING, cmp);
    }

    public static ItemStack[] getLastCraftingItems(ItemStack stack) {
        return ItemCraftingHalo.getCraftingItems(stack, 12);
    }

    public static ItemStack[] getCraftingItems(ItemStack stack, int slot) {
        ItemStack[] stackArray = new ItemStack[10];
        NBTTagCompound cmp = ItemCraftingHalo.getStoredRecipeCompound(stack, slot);
        if (cmp != null) {
            for (int i = 0; i < stackArray.length; ++i) {
                stackArray[i] = ItemCraftingHalo.getLastCraftingItem(cmp, i);
            }
        }
        return stackArray;
    }

    public static NBTTagCompound getLastCraftingCompound(ItemStack stack, boolean nullify) {
        return ItemNBTHelper.getCompound(stack, TAG_LAST_CRAFTING, nullify);
    }

    public static NBTTagCompound getStoredRecipeCompound(ItemStack stack, int slot) {
        return slot == 12 ? ItemCraftingHalo.getLastCraftingCompound(stack, true) : ItemNBTHelper.getCompound(stack, TAG_STORED_RECIPE_PREFIX + slot, true);
    }

    public static ItemStack getLastCraftingItem(ItemStack stack, int pos) {
        return ItemCraftingHalo.getLastCraftingItem(ItemCraftingHalo.getLastCraftingCompound(stack, true), pos);
    }

    public static ItemStack getLastCraftingItem(NBTTagCompound cmp, int pos) {
        if (cmp == null) {
            return null;
        }
        NBTTagCompound cmp1 = cmp.func_74775_l(TAG_ITEM_PREFIX + pos);
        if (cmp1 == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp1);
    }

    public static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_EQUIPPED, false);
    }

    public static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean(stack, TAG_EQUIPPED, equipped);
    }

    public static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat(stack, TAG_ROTATION_BASE, 0.0f);
    }

    public static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat(stack, TAG_ROTATION_BASE, rotation);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = PlayerHelper.getFirstHeldItemClass((EntityPlayer)player, ItemCraftingHalo.class);
        if (stack != null) {
            this.render(stack, (EntityPlayer)player, event.getPartialTicks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, float partialTicks) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.func_178181_a();
        try {
            renderPosX = ClientMethodHandles.renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = ClientMethodHandles.renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = ClientMethodHandles.renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(posX - renderPosX), (double)(posY - renderPosY + (double)player.getDefaultEyeHeight()), (double)(posZ - renderPosZ));
        float base = ItemCraftingHalo.getRotationBase(stack);
        int angles = 360;
        int segAngles = angles / 12;
        float shift = base - (float)(segAngles / 2);
        float u = 1.0f;
        float v = 0.25f;
        float s = 3.0f;
        float m = 0.8f;
        float y = v * s * 2.0f;
        float y0 = 0.0f;
        int segmentLookedAt = ItemCraftingHalo.getSegmentLookedAt(stack, (EntityLivingBase)player);
        for (int seg = 0; seg < 12; ++seg) {
            ItemStack slotStack;
            boolean inside = false;
            float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)(s * m), (float)-0.75f, (float)0.0f);
            if (segmentLookedAt == seg) {
                inside = true;
            }
            if ((slotStack = ItemCraftingHalo.getItemForSlot(stack, seg)) != null) {
                mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                RenderHelper.func_74519_b();
                float scale = seg == 0 ? 0.9f : 0.8f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)(seg == 0 ? 0.5f : 0.0f), (float)(seg == 0 ? -0.1f : 0.6f), (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(slotStack, ItemCameraTransforms.TransformType.GUI);
                RenderHelper.func_74518_a();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float a = alpha;
            if (inside) {
                a += 0.3f;
                y0 = -y;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (seg % 2 == 0) {
                GlStateManager.func_179131_c((float)0.6f, (float)0.6f, (float)0.6f, (float)a);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            GlStateManager.func_179129_p();
            ItemCraftingHalo item = (ItemCraftingHalo)stack.func_77973_b();
            mc.field_71446_o.func_110577_a(item.getGlowResource());
            tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i < segAngles; ++i) {
                float ang = (float)(i + seg * segAngles) + shift;
                double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)s;
                double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)s;
                tess.func_178180_c().func_181662_b(xp * (double)m, (double)y, zp * (double)m).func_187315_a((double)u, (double)v).func_181675_d();
                tess.func_178180_c().func_181662_b(xp, (double)y0, zp).func_187315_a((double)u, 0.0).func_181675_d();
                xp = Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                zp = Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                tess.func_178180_c().func_181662_b(xp, (double)y0, zp).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_178180_c().func_181662_b(xp * (double)m, (double)y, zp * (double)m).func_187315_a(0.0, (double)v).func_181675_d();
            }
            y0 = 0.0f;
            tess.func_78381_a();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getGlowResource() {
        return glowTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(ScaledResolution resolution, EntityPlayer player, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        int slot = ItemCraftingHalo.getSegmentLookedAt(stack, (EntityLivingBase)player);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (slot == 0) {
            String name = craftingTable.func_82833_r();
            int l = mc.field_71466_p.func_78256_a(name);
            int x = resolution.func_78326_a() / 2 - l / 2;
            int y = resolution.func_78328_b() / 2 - 65;
            Gui.func_73734_a((int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x22000000);
            Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x22000000);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            mc.func_175599_af().func_180450_b(craftingTable, resolution.func_78326_a() / 2 - 8, resolution.func_78328_b() / 2 - 52);
            RenderHelper.func_74518_a();
            mc.field_71466_p.func_175063_a(name, (float)x, (float)y, 0xFFFFFF);
        } else {
            ItemStack[] recipe = ItemCraftingHalo.getCraftingItems(stack, slot);
            String label = I18n.func_135052_a((String)"botaniamisc.unsetRecipe", (Object[])new Object[0]);
            boolean setRecipe = false;
            if (recipe[9] == null) {
                recipe = ItemCraftingHalo.getCraftingItems(stack, 12);
            } else {
                label = recipe[9].func_82833_r();
                setRecipe = true;
            }
            ItemCraftingHalo.renderRecipe(resolution, label, recipe, player, setRecipe);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderRecipe(ScaledResolution resolution, String label, ItemStack[] recipe, EntityPlayer player, boolean setRecipe) {
        Minecraft mc = Minecraft.func_71410_x();
        if (recipe[9] != null) {
            int x = resolution.func_78326_a() / 2 - 45;
            int y = resolution.func_78328_b() / 2 - 90;
            Gui.func_73734_a((int)(x - 6), (int)(y - 6), (int)(x + 90 + 6), (int)(y + 60), (int)0x22000000);
            Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + 90 + 4), (int)(y + 58), (int)0x22000000);
            Gui.func_73734_a((int)(x + 66), (int)(y + 14), (int)(x + 92), (int)(y + 40), (int)0x22000000);
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + 56), (int)(y + 56), (int)0x22000000);
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = recipe[i];
                if (stack == null) continue;
                int xpos = x + i % 3 * 18;
                int ypos = y + i / 3 * 18;
                Gui.func_73734_a((int)xpos, (int)ypos, (int)(xpos + 16), (int)(ypos + 16), (int)0x22000000);
                mc.func_175599_af().func_180450_b(stack, xpos, ypos);
            }
            mc.func_175599_af().func_180450_b(recipe[9], x + 72, y + 18);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, recipe[9], x + 72, y + 18);
            RenderHelper.func_74518_a();
        }
        int yoff = 110;
        if (setRecipe && !ItemCraftingHalo.canCraft(recipe, ItemCraftingHalo.getFakeInv(player))) {
            String warning = TextFormatting.RED + I18n.func_135052_a((String)"botaniamisc.cantCraft", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(warning, (float)(resolution.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(warning) / 2), (float)(resolution.func_78328_b() / 2 - yoff), 0xFFFFFF);
            yoff += 12;
        }
        mc.field_71466_p.func_175063_a(label, (float)(resolution.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(label) / 2), (float)(resolution.func_78328_b() / 2 - yoff), 0xFFFFFF);
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.craftingHaloCraft;
    }
}

