/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.recipe.ManaGunClipRecipe;
import vazkii.botania.common.crafting.recipe.ManaGunLensRecipe;
import vazkii.botania.common.crafting.recipe.ManaGunRemoveLensRecipe;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ItemMod;

public class ItemManaGun
extends ItemMod
implements IManaUsingItem {
    private static final String TAG_LENS = "lens";
    private static final String TAG_CLIP = "clip";
    private static final String TAG_CLIP_POS = "clipPos";
    private static final int CLIP_SLOTS = 6;
    private static final int COOLDOWN = 30;

    public ItemManaGun() {
        super("manaGun");
        this.func_77656_e(30);
        this.func_77625_d(1);
        this.setNoRepair();
        GameRegistry.addRecipe((IRecipe)new ManaGunLensRecipe());
        GameRegistry.addRecipe((IRecipe)new ManaGunRemoveLensRecipe());
        GameRegistry.addRecipe((IRecipe)new ManaGunClipRecipe());
        RecipeSorter.register((String)"botania:manaGunLens", ManaGunLensRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"botania:manaGunRemoveLens", ManaGunRemoveLensRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"botania:manaGunClip", ManaGunClipRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        int effCd = 30;
        PotionEffect effect = player.func_70660_b(MobEffects.field_76422_e);
        if (effect != null) {
            effCd -= (effect.func_76458_c() + 1) * 8;
        }
        if (player.func_70093_af() && ItemManaGun.hasClip(par1ItemStack)) {
            ItemManaGun.rotatePos(par1ItemStack);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187839_fV, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (world.field_72995_K) {
                player.func_184609_a(hand);
            }
            ItemStack lens = ItemManaGun.getLens(par1ItemStack);
            ItemsRemainingRenderHandler.set(lens, -2);
            par1ItemStack.func_77964_b(effCd);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
        }
        if (par1ItemStack.func_77952_i() == 0) {
            EntityManaBurst burst = this.getBurst(player, par1ItemStack, true);
            if (burst != null && ManaItemHandler.requestManaExact(par1ItemStack, player, burst.getMana(), true)) {
                if (!world.field_72995_K) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.manaBlaster, SoundCategory.PLAYERS, 0.6f, 1.0f);
                    player.func_71064_a((StatBase)ModAchievements.manaBlasterShoot, 1);
                    if (this.isSugoiKawaiiDesuNe(par1ItemStack)) {
                        player.func_71064_a((StatBase)ModAchievements.desuGun, 1);
                    }
                    world.func_72838_d((Entity)burst);
                } else {
                    player.func_184609_a(hand);
                    player.field_70159_w -= burst.field_70159_w * 0.1;
                    player.field_70181_x -= burst.field_70181_x * 0.3;
                    player.field_70179_y -= burst.field_70179_y * 0.1;
                }
                par1ItemStack.func_77964_b(effCd);
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)par1ItemStack);
    }

    private boolean isSugoiKawaiiDesuNe(ItemStack stack) {
        return stack.func_82833_r().equalsIgnoreCase("desu gun");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemManaGun.getLens(stack) != null;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return ItemManaGun.getLens(itemStack);
    }

    public EntityManaBurst getBurst(EntityPlayer player, ItemStack stack, boolean request) {
        EntityManaBurst burst = new EntityManaBurst(player);
        int maxMana = 120;
        int color = 0x20FF20;
        int ticksBeforeManaLoss = 60;
        float manaLossPerTick = 4.0f;
        float motionModifier = 5.0f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = ItemManaGun.getLens(stack);
        if (lens != null) {
            ((ILens)lens.func_77973_b()).apply(lens, props);
        }
        burst.setSourceLens(lens);
        if (!request || ManaItemHandler.requestManaExact(stack, player, props.maxMana, false)) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.setMotion(burst.field_70159_w * (double)props.motionModifier, burst.field_70181_x * (double)props.motionModifier, burst.field_70179_y * (double)props.motionModifier);
            return burst;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer player, List<String> stacks, boolean par4) {
        List tooltip;
        boolean clip = ItemManaGun.hasClip(par1ItemStack);
        if (clip && !GuiScreen.func_146272_n()) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), stacks);
            return;
        }
        ItemStack lens = ItemManaGun.getLens(par1ItemStack);
        if (lens != null && (tooltip = lens.func_82840_a(player, false)).size() > 1) {
            stacks.addAll(tooltip.subList(1, tooltip.size()));
        }
        if (clip) {
            int pos = ItemManaGun.getClipPos(par1ItemStack);
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasClip", (Object[])new Object[0]), stacks);
            for (int i = 0; i < 6; ++i) {
                TextFormatting formatting = i == pos ? TextFormatting.GREEN : TextFormatting.GRAY;
                ItemStack lensAt = ItemManaGun.getLensAtPos(par1ItemStack, i);
                String name = lensAt == null ? I18n.func_135052_a((String)"botaniamisc.clipEmpty", (Object[])new Object[0]) : lensAt.func_82833_r();
                this.addStringToTooltip(formatting + " - " + name, stacks);
            }
        }
    }

    private void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack par1ItemStack) {
        ItemStack lens = ItemManaGun.getLens(par1ItemStack);
        return super.func_77653_i(par1ItemStack) + (lens == null ? "" : " (" + TextFormatting.GREEN + lens.func_82833_r() + TextFormatting.RESET + ")");
    }

    public static boolean hasClip(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
    }

    public static void setClip(ItemStack stack, boolean clip) {
        ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
    }

    public static int getClipPos(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
    }

    public static void setClipPos(ItemStack stack, int pos) {
        ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
    }

    public static void rotatePos(ItemStack stack) {
        int currPos = ItemManaGun.getClipPos(stack);
        boolean acceptEmpty = ItemManaGun.getLensAtPos(stack, currPos) != null;
        int[] slots = new int[5];
        int index = 0;
        int i = currPos + 1;
        while (i < 6) {
            slots[index] = i++;
            ++index;
        }
        i = 0;
        while (i < currPos) {
            slots[index] = i++;
            ++index;
        }
        for (int i2 : slots) {
            ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i2);
            if (!acceptEmpty && lensAt == null) continue;
            ItemManaGun.setClipPos(stack, i2);
            return;
        }
    }

    public static ItemStack getLensAtPos(ItemStack stack, int pos) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
        if (cmp != null) {
            return ItemStack.func_77949_a((NBTTagCompound)cmp);
        }
        return null;
    }

    public static void setLensAtPos(ItemStack stack, ItemStack lens, int pos) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (lens != null) {
            lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
    }

    public static void setLens(ItemStack stack, ItemStack lens) {
        if (ItemManaGun.hasClip(stack)) {
            ItemManaGun.setLensAtPos(stack, lens, ItemManaGun.getClipPos(stack));
        }
        NBTTagCompound cmp = new NBTTagCompound();
        if (lens != null) {
            lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
    }

    public static ItemStack getLens(ItemStack stack) {
        if (ItemManaGun.hasClip(stack)) {
            return ItemManaGun.getLensAtPos(stack, ItemManaGun.getClipPos(stack));
        }
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
        if (cmp != null) {
            ItemStack lens = ItemStack.func_77949_a((NBTTagCompound)cmp);
            return lens;
        }
        return null;
    }

    public static List<ItemStack> getAllLens(ItemStack stack) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ret.add(ItemManaGun.getLensAtPos(stack, i));
        }
        return ret;
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77951_h()) {
            par1ItemStack.func_77964_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("botania:desuGunClip", "inventory"), new ModelResourceLocation("botania:desuGun", "inventory"), new ModelResourceLocation("botania:manaGunClip", "inventory"), new ModelResourceLocation("botania:manaGun", "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            if (ItemManaGun.hasClip(stack) && this.isSugoiKawaiiDesuNe(stack)) {
                return new ModelResourceLocation("botania:desuGunClip", "inventory");
            }
            if (this.isSugoiKawaiiDesuNe(stack)) {
                return new ModelResourceLocation("botania:desuGun", "inventory");
            }
            if (ItemManaGun.hasClip(stack)) {
                return new ModelResourceLocation("botania:manaGunClip", "inventory");
            }
            return new ModelResourceLocation("botania:manaGun", "inventory");
        });
    }
}

