/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.IRecipeKeyProvider;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.block.ItemBlockMod;

public class ItemBlockSpecialFlower
extends ItemBlockMod
implements IRecipeKeyProvider {
    public ItemBlockSpecialFlower(Block block1) {
        super(block1);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (placed) {
            String type = ItemBlockSpecialFlower.getType(stack);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileSpecialFlower) {
                TileSpecialFlower tile = (TileSpecialFlower)te;
                tile.setSubTile(type);
                tile.onBlockAdded(world, pos, newState);
                tile.onBlockPlacedBy(world, pos, newState, (EntityLivingBase)player, stack);
                if (!world.field_72995_K) {
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 8);
                }
            }
        }
        return placed;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return BotaniaAPI.getSignatureForName(ItemBlockSpecialFlower.getType(stack)).getUnlocalizedNameForStack(stack);
    }

    @Override
    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return this.getUnlocalizedNameInefficiently_(par1ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack par1ItemStack, @Nonnull EntityPlayer player, @Nonnull List<String> stacks, boolean par4) {
        String mod;
        String refUnlocalized;
        String refLocalized;
        String type = ItemBlockSpecialFlower.getType(par1ItemStack);
        SubTileSignature sig = BotaniaAPI.getSignatureForName(type);
        sig.addTooltip(par1ItemStack, player, stacks);
        if (ConfigHandler.referencesEnabled && !(refLocalized = I18n.func_135052_a((String)(refUnlocalized = sig.getUnlocalizedLoreTextForStack(par1ItemStack)), (Object[])new Object[0])).equals(refUnlocalized)) {
            stacks.add(TextFormatting.ITALIC + refLocalized);
        }
        if (!(mod = BotaniaAPI.subTileMods.get(type)).equals("Botania")) {
            stacks.add(TextFormatting.ITALIC + "[" + mod + "]");
        }
    }

    public static String getType(ItemStack stack) {
        return ItemNBTHelper.detectNBT(stack) ? ItemNBTHelper.getString(stack, "type", "") : "";
    }

    public static ItemStack ofType(String type) {
        return ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.specialFlower), type);
    }

    public static ItemStack ofType(ItemStack stack, String type) {
        ItemNBTHelper.setString(stack, "type", type);
        return stack;
    }

    @Override
    public String getKey(ItemStack stack) {
        return "flower." + ItemBlockSpecialFlower.getType(stack);
    }

    @Override
    public Achievement getAchievementOnPickup(ItemStack stack, EntityPlayer player, EntityItem item) {
        String type;
        switch (type = ItemBlockSpecialFlower.getType(stack)) {
            case "kekimurus": {
                return ModAchievements.kekimurusPickup;
            }
            case "heiseiDream": {
                return ModAchievements.heiseiDreamPickup;
            }
            case "pollidisiac": {
                return ModAchievements.pollidisiacPickup;
            }
            case "bubbell": {
                return ModAchievements.bubbellPickup;
            }
            case "dandelifeon": {
                return ModAchievements.dandelifeonPickup;
            }
            case "": {
                return ModAchievements.nullFlower;
            }
        }
        Class<? extends SubTileEntity> clazz = BotaniaAPI.getSubTileMapping(type);
        if (SubTileGenerating.class.isAssignableFrom(clazz)) {
            return ModAchievements.daybloomPickup;
        }
        if (SubTileFunctional.class.isAssignableFrom(clazz)) {
            return ModAchievements.endoflamePickup;
        }
        return null;
    }
}

