/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.common.lib.PlayerHandler;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSyncBauble;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemItemFinder
extends ItemBauble
implements IBaubleRender {
    private static final String TAG_POSITIONS_OLD = "highlightPositions";
    private static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
    private static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock1";

    public ItemItemFinder() {
        super("itemFinder");
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            this.tickClient(stack, (EntityPlayer)player);
        } else {
            this.tickServer(stack, (EntityPlayer)player);
        }
    }

    protected void tickClient(ItemStack stack, EntityPlayer player) {
        int[] entities;
        if (!Botania.proxy.isTheClientPlayer((EntityLivingBase)player)) {
            return;
        }
        long[] blocks = this.getBlockPositions(stack);
        Botania.proxy.setWispFXDepthTest(false);
        for (long l : blocks) {
            BlockPos pos = BlockPos.func_177969_a((long)l);
            float m = 0.02f;
            Botania.proxy.wispFX((float)pos.func_177958_n() + (float)Math.random(), (float)pos.func_177956_o() + (float)Math.random(), (float)pos.func_177952_p() + (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.15f + 0.05f * (float)Math.random(), m * (float)(Math.random() - 0.5), m * (float)(Math.random() - 0.5), m * (float)(Math.random() - 0.5));
        }
        for (int i : entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS)) {
            Entity e = player.field_70170_p.func_73045_a(i);
            if (e == null || !(Math.random() < 0.6)) continue;
            Botania.proxy.setWispFXDepthTest(Math.random() < 0.6);
            Botania.proxy.wispFX(e.field_70165_t + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.field_70163_u + (double)e.field_70131_O, e.field_70161_v + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.15f + 0.05f * (float)Math.random(), -0.05f - 0.03f * (float)Math.random());
        }
        Botania.proxy.setWispFXDepthTest(true);
    }

    protected void tickServer(ItemStack stack, EntityPlayer player) {
        ItemNBTHelper.removeEntry(stack, TAG_POSITIONS_OLD);
        TIntArrayList entPosBuilder = new TIntArrayList();
        TLongArrayList blockPosBuilder = new TLongArrayList();
        this.scanForStack(player.func_184614_ca(), player, entPosBuilder, blockPosBuilder);
        this.scanForStack(player.func_184592_cb(), player, entPosBuilder, blockPosBuilder);
        int[] currentEnts = entPosBuilder.toArray();
        long[] currentBlocks = blockPosBuilder.toArray();
        boolean entsEqual = Arrays.equals(currentEnts, ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS));
        boolean blocksEqual = Arrays.equals(currentBlocks, this.getBlockPositions(stack));
        if (!entsEqual) {
            ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, currentEnts);
        }
        if (!blocksEqual) {
            this.setBlockPositions(stack, currentBlocks);
        }
        if (!entsEqual || !blocksEqual) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSyncBauble(player, 0));
        }
    }

    private void scanForStack(ItemStack pstack, EntityPlayer player, TIntArrayList entIdBuilder, TLongArrayList blockPosBuilder) {
        if (pstack != null || player.func_70093_af()) {
            int range = 24;
            List entities = player.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(player.field_70165_t - (double)range, player.field_70163_u - (double)range, player.field_70161_v - (double)range, player.field_70165_t + (double)range, player.field_70163_u + (double)range, player.field_70161_v + (double)range));
            block0: for (Entity e : entities) {
                if (e == player) continue;
                if (e.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && !(e instanceof EntityPlayer)) {
                    if (!this.scanInventory((IItemHandler)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), pstack)) continue;
                    entIdBuilder.add(e.func_145782_y());
                    continue;
                }
                if (e instanceof EntityItem) {
                    EntityItem item = (EntityItem)e;
                    ItemStack istack = item.func_92059_d();
                    if (!player.func_70093_af() && (!istack.func_77969_a(pstack) || !ItemStack.func_77970_a((ItemStack)istack, (ItemStack)pstack))) continue;
                    entIdBuilder.add(item.func_145782_y());
                    continue;
                }
                if (e instanceof IInventory) {
                    IInventory inv = (IInventory)e;
                    if (!this.scanInventory((IItemHandler)new InvWrapper(inv), pstack)) continue;
                    entIdBuilder.add(e.func_145782_y());
                    continue;
                }
                if (e instanceof EntityPlayer) {
                    EntityPlayer player_ = (EntityPlayer)e;
                    IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    InvWrapper binv = new InvWrapper((IInventory)PlayerHandler.getPlayerBaubles((EntityPlayer)player_));
                    if (!this.scanInventory((IItemHandler)binv, pstack) && !this.scanInventory(playerInv, pstack)) continue;
                    entIdBuilder.add(player_.func_145782_y());
                    continue;
                }
                if (!(e instanceof EntityVillager)) continue;
                EntityVillager villager = (EntityVillager)e;
                MerchantRecipeList recipes = villager.func_70934_b(player);
                if (pstack == null || recipes == null) continue;
                for (EnumFacing[] recipe : recipes) {
                    if (recipe == null || recipe.func_82784_g() || !this.equalStacks(pstack, recipe.func_77394_a()) && !this.equalStacks(pstack, recipe.func_77397_d())) continue;
                    entIdBuilder.add(villager.func_145782_y());
                    continue block0;
                }
            }
            if (pstack != null) {
                range = 12;
                BlockPos pos = new BlockPos((Entity)player);
                for (BlockPos pos_ : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range + 1, range + 1, range + 1))) {
                    IInventory inv;
                    TileEntity tile = player.field_70170_p.func_175625_s(pos_);
                    if (tile == null) continue;
                    boolean foundCap = false;
                    for (EnumFacing e : EnumFacing.field_82609_l) {
                        if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e) || !this.scanInventory((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e), pstack)) continue;
                        blockPosBuilder.add(pos_.func_177986_g());
                        foundCap = true;
                        break;
                    }
                    if (foundCap || !(tile instanceof IInventory) || !this.scanInventory((IItemHandler)new InvWrapper(inv = (IInventory)tile), pstack)) continue;
                    blockPosBuilder.add(pos_.func_177986_g());
                }
            }
        }
    }

    private boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private boolean scanInventory(IItemHandler inv, ItemStack pstack) {
        if (pstack == null) {
            return false;
        }
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack istack = inv.getStackInSlot(l);
            if (istack == null || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    private long[] getBlockPositions(ItemStack stack) {
        int[] ints = ItemNBTHelper.getIntArray(stack, TAG_BLOCK_POSITIONS);
        return MathHelper.intArrayToLongArray(ints);
    }

    private void setBlockPositions(ItemStack stack, long[] vals) {
        stack.func_77978_p().func_82580_o(TAG_BLOCK_POSITIONS);
        int[] write = MathHelper.longArrayToIntArray(vals);
        ItemNBTHelper.setIntArray(stack, TAG_BLOCK_POSITIONS, write);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        TextureAtlasSprite gemIcon = MiscellaneousIcons.INSTANCE.itemFinderGem;
        if (type == IBaubleRender.RenderType.HEAD) {
            float f = gemIcon.func_94209_e();
            float f1 = gemIcon.func_94212_f();
            float f2 = gemIcon.func_94206_g();
            float f3 = gemIcon.func_94210_h();
            boolean armor = player.func_184582_a(EntityEquipmentSlot.HEAD) != null;
            IBaubleRender.Helper.translateToHeadLevel(player);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.4f, (float)-1.4f, (float)(armor ? -0.3f : -0.25f));
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, gemIcon.func_94211_a(), gemIcon.func_94216_b(), 0.0625f);
        }
    }
}

