/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemMod;

public class ItemDiviningRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatarDivining.png");
    static final int COST = 3000;

    public ItemDiviningRod() {
        super("diviningRod");
        this.func_77625_d(1);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer p, EnumHand hand) {
        if (ManaItemHandler.requestManaExactForTool(stack, p, 3000, true)) {
            if (world.field_72995_K) {
                int range = IManaProficiencyArmor.Helper.hasProficiency(p) ? 20 : 15;
                long seedxor = world.field_73012_v.nextLong();
                this.doHighlight(world, new BlockPos((Entity)p), range, seedxor);
                p.func_184609_a(hand);
            } else {
                world.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, BotaniaSoundEvents.divinationRod, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void doHighlight(World world, BlockPos pos, int range, long seedxor) {
        Botania.proxy.setWispFXDepthTest(false);
        block0: for (BlockPos pos_ : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range))) {
            IBlockState state = world.func_180495_p(pos_);
            if (Item.func_150898_a((Block)state.func_177230_c()) == null) continue;
            ItemStack orestack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            for (int id : OreDictionary.getOreIDs((ItemStack)orestack)) {
                String s = OreDictionary.getOreName((int)id);
                if (!s.matches("^ore[A-Z].+")) continue;
                Random rand = new Random((long)s.hashCode() ^ seedxor);
                Botania.proxy.wispFX((float)pos_.func_177958_n() + world.field_73012_v.nextFloat(), (float)pos_.func_177956_o() + world.field_73012_v.nextFloat(), (float)pos_.func_177952_p() + world.field_73012_v.nextFloat(), rand.nextFloat(), rand.nextFloat(), rand.nextFloat(), 0.25f, 0.0f, 8.0f);
                continue block0;
            }
        }
        Botania.proxy.setWispFXDepthTest(true);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (tile.getCurrentMana() >= 3000 && tile.getElapsedFunctionalTicks() % 200 == 0 && tile.isEnabled()) {
            this.doHighlight(world, te.func_174877_v(), 18, te.func_174877_v().hashCode());
            tile.recieveMana(-3000);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

