/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSmeltRod
extends ItemMod
implements IManaUsingItem {
    private static final int TIME = 10;
    private static final int COST = 300;
    private static final int COST_PER_TICK = 30;
    public static final Map<EntityPlayer, SmeltData> playerData = new WeakHashMap<EntityPlayer, SmeltData>();

    public ItemSmeltRod() {
        super("smeltRod");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int time) {
        if (!(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)living;
        if (!ManaItemHandler.requestManaExactForTool(stack, p, 30, false)) {
            return;
        }
        RayTraceResult pos = ToolCommons.raytraceFromEntity(p.field_70170_p, (Entity)p, false, 32.0);
        if (pos != null && pos.func_178782_a() != null) {
            IBlockState state = p.field_70170_p.func_180495_p(pos.func_178782_a());
            ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(blockStack);
            if (result != null && result.func_77973_b() instanceof ItemBlock) {
                SmeltData data;
                boolean decremented = false;
                if (playerData.containsKey(p) && (data = playerData.get(p)).equalPos(pos)) {
                    --data.progress;
                    decremented = true;
                    if (data.progress <= 0) {
                        if (!p.field_70170_p.field_72995_K) {
                            p.field_70170_p.func_180501_a(pos.func_178782_a(), Block.func_149634_a((Item)result.func_77973_b()).func_176203_a(result.func_77952_i()), 3);
                            p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.6f, 1.0f);
                            p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            ManaItemHandler.requestManaExactForTool(stack, p, 30, true);
                            playerData.remove(p);
                            decremented = false;
                        }
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)pos.func_178782_a().func_177958_n() + Math.random();
                            double y = (double)pos.func_178782_a().func_177956_o() + Math.random();
                            double z = (double)pos.func_178782_a().func_177952_p() + Math.random();
                            Botania.proxy.wispFX(x, y, z, 1.0f, 0.2f, 0.2f, 0.5f, (float)(-Math.random()) / 10.0f);
                        }
                    }
                }
                if (!decremented) {
                    playerData.put(p, new SmeltData(pos, IManaProficiencyArmor.Helper.hasProficiency(p) ? 6 : 10));
                } else {
                    for (int i = 0; i < 2; ++i) {
                        double x = (double)pos.func_178782_a().func_177958_n() + Math.random();
                        double y = (double)pos.func_178782_a().func_177956_o() + Math.random();
                        double z = (double)pos.func_178782_a().func_177952_p() + Math.random();
                        Botania.proxy.wispFX(x, y, z, 1.0f, 0.2f, 0.2f, 0.5f, (float)(-Math.random()) / 10.0f);
                    }
                    if (time % 10 == 0) {
                        p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, (float)Math.random() / 2.0f + 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    static class SmeltData {
        public final RayTraceResult pos;
        public int progress;

        public SmeltData(RayTraceResult pos, int progress) {
            this.pos = pos;
            this.progress = progress;
        }

        public boolean equalPos(RayTraceResult pos) {
            return pos.func_178782_a().equals((Object)this.pos.func_178782_a());
        }
    }
}

