/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.common.Botania;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemTornadoRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatarTornado.png");
    private static final int FLY_TIME = 20;
    private static final int FALL_MULTIPLIER = 3;
    private static final int MAX_DAMAGE = 60;
    private static final int COST = 350;
    private static final String TAG_FLYING = "flying";

    public ItemTornadoRod() {
        super("tornadoRod");
        this.func_77656_e(60);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("botania", TAG_FLYING), (stack, world, living) -> this.isFlying(stack) ? 1.0f : 0.0f);
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean holding) {
        if (par3Entity instanceof EntityPlayer) {
            boolean damaged;
            EntityPlayer player = (EntityPlayer)par3Entity;
            boolean bl = damaged = par1ItemStack.func_77952_i() > 0;
            if (damaged && !this.isFlying(par1ItemStack)) {
                par1ItemStack.func_77964_b(par1ItemStack.func_77952_i() - 1);
            }
            int max = 60;
            if (par1ItemStack.func_77952_i() >= max) {
                this.setFlying(par1ItemStack, false);
                player.func_184602_cy();
            } else if (this.isFlying(par1ItemStack)) {
                if (holding) {
                    player.field_70143_R = 0.0f;
                    player.field_70181_x = IManaProficiencyArmor.Helper.hasProficiency(player) ? 1.6 : 1.25;
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, BotaniaSoundEvents.airRod, SoundCategory.PLAYERS, 0.1f, 0.25f);
                    for (int i = 0; i < 5; ++i) {
                        Botania.proxy.wispFX(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.25f, 0.25f, 0.25f, 0.35f + (float)Math.random() * 0.1f, 0.2f * (float)(Math.random() - 0.5), -0.01f * (float)Math.random(), 0.2f * (float)(Math.random() - 0.5));
                    }
                }
                par1ItemStack.func_77964_b(Math.min(max, par1ItemStack.func_77952_i() + 3));
                if (par1ItemStack.func_77952_i() == 60) {
                    this.setFlying(par1ItemStack, false);
                }
            }
            if (damaged) {
                player.field_70143_R = 0.0f;
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        int meta = par1ItemStack.func_77952_i();
        if (meta != 0 || ManaItemHandler.requestManaExactForTool(par1ItemStack, player, 350, false)) {
            player.func_184598_c(hand);
            if (meta == 0) {
                ManaItemHandler.requestManaExactForTool(par1ItemStack, player, 350, true);
                this.setFlying(par1ItemStack, true);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)par1ItemStack);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 720000;
    }

    public boolean isFlying(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
    }

    public void setFlying(ItemStack stack, boolean flying) {
        ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (tile.getCurrentMana() >= 350 && tile.isEnabled()) {
            int range = 5;
            int rangeY = 3;
            List players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(te.func_174877_v().func_177963_a(-0.5 - (double)range, -0.5 - (double)rangeY, -0.5 - (double)range), te.func_174877_v().func_177963_a(0.5 + (double)range, 0.5 + (double)rangeY, 0.5 + (double)range)));
            for (EntityPlayer p : players) {
                if (!(p.field_70181_x > 0.3) || !(p.field_70181_x < 2.0) || p.func_70093_af()) continue;
                p.field_70181_x = 2.8;
                for (int i = 0; i < 20; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        Botania.proxy.wispFX(p.field_70165_t, p.field_70163_u + (double)i, p.field_70161_v, 0.25f, 0.25f, 0.25f, 0.35f + (float)Math.random() * 0.1f, 0.2f * (float)(Math.random() - 0.5), -0.01f * (float)Math.random(), 0.2f * (float)(Math.random() - 0.5));
                    }
                }
                if (world.field_72995_K) continue;
                p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, BotaniaSoundEvents.dash, SoundCategory.PLAYERS, 1.0f, 1.0f);
                p.func_70690_d(new PotionEffect(ModPotions.featherfeet, 100, 0));
                tile.recieveMana(-350);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return newStack.func_77973_b() != this || this.isFlying(oldStack) != this.isFlying(newStack);
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

