/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import java.util.Map;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationShieldRegistry;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.getWorld();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getPos().func_177958_n();
        int y = event.getPos().func_177956_o();
        int z = event.getPos().func_177952_p();
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            BlockPos c = gc.getCoordinate();
            if (!((float)Math.abs(c.func_177958_n() - x) < radius) || !((float)Math.abs(c.func_177956_o() - y) < radius) || !((float)Math.abs(c.func_177952_p() - z) < radius)) continue;
            Logging.logDebug((String)("Removed blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            radiationTree.addBlocker(x, y, z, 1.0f);
        }
    }

    @SubscribeEvent
    public void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        float blocker = RadiationShieldRegistry.getBlocker(event.getState());
        if (blocker >= 0.99f) {
            return;
        }
        World world = event.getBlockSnapshot().getWorld();
        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
        Map<GlobalCoordinate, DRRadiationManager.RadiationSource> radiationSources = radiationManager.getRadiationSources();
        if (radiationSources.isEmpty()) {
            return;
        }
        int x = event.getBlockSnapshot().getPos().func_177958_n();
        int y = event.getBlockSnapshot().getPos().func_177956_o();
        int z = event.getBlockSnapshot().getPos().func_177952_p();
        for (Map.Entry<GlobalCoordinate, DRRadiationManager.RadiationSource> entry : radiationSources.entrySet()) {
            DRRadiationManager.RadiationSource source = entry.getValue();
            float radius = source.getRadius();
            GlobalCoordinate gc = entry.getKey();
            BlockPos c = gc.getCoordinate();
            if (!((float)Math.abs(c.func_177958_n() - x) < radius) || !((float)Math.abs(c.func_177956_o() - y) < radius) || !((float)Math.abs(c.func_177952_p() - z) < radius)) continue;
            Logging.logDebug((String)("Add blocker at: " + x + "," + y + "," + z));
            QuadTree radiationTree = source.getRadiationTree(world, c.func_177958_n(), c.func_177956_o(), c.func_177952_p());
            radiationTree.addBlocker(x, y, z, blocker);
        }
    }
}

