/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.collector;

import java.util.List;
import mcjty.deepresonance.blocks.GenericDRBlock;
import mcjty.deepresonance.blocks.collector.EnergyCollectorTESR;
import mcjty.deepresonance.blocks.collector.EnergyCollectorTileEntity;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.lib.container.EmptyContainer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EnergyCollectorBlock
extends GenericDRBlock<EnergyCollectorTileEntity, EmptyContainer> {
    public EnergyCollectorBlock() {
        super(Material.field_151573_f, EnergyCollectorTileEntity.class, EmptyContainer.class, "energy_collector", false);
    }

    public boolean hasNoRotation() {
        return true;
    }

    public int getGuiID() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(EnergyCollectorTileEntity.class, (TileEntitySpecialRenderer)new EnergyCollectorTESR());
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advancedToolTip) {
        super.addInformation(itemStack, player, list, advancedToolTip);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("Part of a generator multi-block.");
            list.add("Place this on top of a generator with");
            list.add("crystals nearby.");
        } else {
            list.add(TextFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        GeneratorTileEntity generatorTileEntity;
        DRGeneratorNetwork.Network network;
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos.func_177977_b())) instanceof GeneratorTileEntity && (network = (generatorTileEntity = (GeneratorTileEntity)te).getNetwork()) != null) {
            network.incCollectorBlocks();
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
            generatorNetwork.save(world);
            EnergyCollectorTileEntity energyCollectorTileEntity = (EnergyCollectorTileEntity)world.func_175625_s(pos);
            energyCollectorTileEntity.setNetworkID(generatorTileEntity.getNetworkId());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        DRGeneratorNetwork.Network network;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnergyCollectorTileEntity) {
            EnergyCollectorTileEntity energyCollectorTileEntity = (EnergyCollectorTileEntity)te;
            energyCollectorTileEntity.disableCrystalGlow();
        }
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() == GeneratorSetup.generatorBlock && (te = world.func_175625_s(pos.func_177977_b())) instanceof GeneratorTileEntity && (network = ((GeneratorTileEntity)te).getNetwork()) != null) {
            network.decCollectorBlocks();
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
            generatorNetwork.save(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

