/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystalizer;

import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.crystalizer.CrystalizerContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CrystalizerTileEntity
extends GenericEnergyReceiverTileEntity
implements ITankHook,
DefaultSidedInventory,
ITickable {
    public static final String CMD_GETPROGRESS = "getProgress";
    public static final String CLIENTCMD_GETPROGRESS = "getProgress";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CrystalizerContainer.factory, 1);
    private TileTank rclTank;
    private static int totalProgress = 0;
    private int progress = 0;
    private LiquidCrystalFluidTagData mergedData = null;
    private static int clientProgress = 0;

    public CrystalizerTileEntity() {
        super(ConfigMachines.Crystalizer.rfMaximum, ConfigMachines.Crystalizer.rfPerTick);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public static int getTotalProgress() {
        if (totalProgress == 0) {
            totalProgress = ConfigMachines.Crystalizer.rclPerCrystal / ConfigMachines.Crystalizer.rclPerTick;
        }
        return totalProgress;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.canCrystalize()) {
            return;
        }
        this.storage.extractEnergy(ConfigMachines.Crystalizer.rfPerRcl, false);
        FluidStack fluidStack = this.rclTank.getTank().drain(ConfigMachines.Crystalizer.rclPerTick, true);
        LiquidCrystalFluidTagData data = LiquidCrystalFluidTagData.fromStack(fluidStack);
        if (this.mergedData == null) {
            this.mergedData = data;
        } else {
            this.mergedData.merge(data);
        }
        this.handleProgress();
    }

    private void handleProgress() {
        ++this.progress;
        if (this.progress == 1) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
        if (this.progress >= CrystalizerTileEntity.getTotalProgress()) {
            this.progress = 0;
            this.makeCrystal();
            this.markDirtyClient();
        }
        this.func_70296_d();
    }

    public int getProgress() {
        return this.progress;
    }

    public static int getClientProgress() {
        return clientProgress;
    }

    private boolean canCrystalize() {
        if (this.rclTank == null || this.rclTank.getTank() == null) {
            return false;
        }
        if (this.storage.getEnergyStored() < ConfigMachines.Crystalizer.rfPerRcl) {
            return false;
        }
        if (this.hasCrystal()) {
            return false;
        }
        FluidStack fluidStack = this.rclTank.getTank().drain(ConfigMachines.Crystalizer.rclPerTick, false);
        return fluidStack != null && fluidStack.amount == ConfigMachines.Crystalizer.rclPerTick;
    }

    public boolean hasCrystal() {
        ItemStack crystalStack = this.inventoryHelper.getStackInSlot(0);
        return crystalStack != null;
    }

    private void makeCrystal() {
        ItemStack stack = new ItemStack((Block)ModBlocks.resonatingCrystalBlock);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("power", 100.0f);
        compound.func_74776_a("strength", this.mergedData.getStrength() * 100.0f);
        compound.func_74776_a("efficiency", this.mergedData.getEfficiency() * 100.0f);
        compound.func_74776_a("purity", this.mergedData.getPurity() * 100.0f);
        compound.func_74774_a("version", (byte)2);
        stack.func_77982_d(compound);
        this.mergedData = null;
        this.inventoryHelper.setStackInSlot(0, stack);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("progress", this.progress);
        if (this.mergedData != null) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            this.mergedData.writeDataToNBT(dataCompound);
            tagCompound.func_74782_a("data", (NBTBase)dataCompound);
            tagCompound.func_74768_a("amount", this.mergedData.getInternalTankAmount());
        }
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.progress = tagCompound.func_74762_e("progress");
        if (tagCompound.func_74764_b("data")) {
            NBTTagCompound dataCompound = (NBTTagCompound)tagCompound.func_74781_a("data");
            int amount = dataCompound.func_74762_e("amount");
            this.mergedData = LiquidCrystalFluidTagData.fromNBT(dataCompound, amount);
        } else {
            this.mergedData = null;
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    @Override
    public void hook(TileTank tank, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && this.rclTank == null && this.validRCLTank(tank)) {
            this.rclTank = tank;
        }
    }

    @Override
    public void unHook(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.rclTank, tank)) {
            this.rclTank = null;
            this.notifyAndMarkDirty();
        }
    }

    @Override
    public void onContentChanged(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.rclTank, tank) && !this.validRCLTank(tank)) {
            this.rclTank = null;
        }
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.func_174877_v().equals((Object)second.func_174877_v()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public void requestProgressFromServer() {
        DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketRequestIntegerFromServer("deepresonance", this.field_174879_c, "getProgress", "getProgress", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getProgress".equals(command)) {
            return this.progress * 100 / CrystalizerTileEntity.getTotalProgress();
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getProgress".equals(command)) {
            clientProgress = result;
            return true;
        }
        return false;
    }

    protected void notifyAndMarkDirty() {
        if (WorldHelper.chunkLoaded((World)this.field_145850_b, (BlockPos)this.field_174879_c)) {
            this.func_70296_d();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
        }
    }
}

