/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import elec332.core.main.ElecCore;
import elec332.core.world.WorldHelper;
import java.text.DecimalFormat;
import java.util.List;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.GenericDRBlock;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTESR;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.boom.TestExplosion;
import mcjty.deepresonance.network.PacketGetCrystalInfo;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResonatingCrystalBlock
extends GenericDRBlock<ResonatingCrystalTileEntity, EmptyContainer> {
    public static PropertyBool EMPTY = PropertyBool.func_177716_a((String)"empty");
    public static PropertyBool GENERATED = PropertyBool.func_177716_a((String)"generated");
    public static int tooltipRFTick = 0;
    public static float tooltipPower = 0.0f;
    private static long lastTime = 0L;
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);

    public ResonatingCrystalBlock() {
        super(Material.field_151592_s, ResonatingCrystalTileEntity.class, EmptyContainer.class, "resonating_crystal", false);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(ResonatingCrystalTileEntity.class, (TileEntitySpecialRenderer)new ResonatingCrystalTESR());
        final ModelResourceLocation emptyNaturalModel = new ModelResourceLocation(this.getRegistryName(), "empty=true,facing=north,generated=false");
        final ModelResourceLocation fullNaturalModel = new ModelResourceLocation(this.getRegistryName(), "empty=false,facing=north,generated=false");
        final ModelResourceLocation emptyGeneratedModel = new ModelResourceLocation(this.getRegistryName(), "empty=true,facing=north,generated=true");
        final ModelResourceLocation fullGeneratedModel = new ModelResourceLocation(this.getRegistryName(), "empty=false,facing=north,generated=true");
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{emptyNaturalModel, fullNaturalModel});
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                float purity;
                float power = stack.func_77978_p() == null ? 1.0f : stack.func_77978_p().func_74760_g("power");
                float f = purity = stack.func_77978_p() == null ? 1.0f : stack.func_77978_p().func_74760_g("purity");
                if (power < 1.0E-5f) {
                    if (purity > 30.0f) {
                        return emptyGeneratedModel;
                    }
                    return emptyNaturalModel;
                }
                if (purity > 30.0f) {
                    return fullGeneratedModel;
                }
                return fullNaturalModel;
            }
        });
    }

    public boolean isHorizRotation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advancedToolTips) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            tagCompound.func_82580_o("owner");
            tagCompound.func_82580_o("ownerM");
            tagCompound.func_82580_o("idM");
        }
        super.addInformation(itemStack, player, list, advancedToolTips);
        float power = 100.0f;
        if (tagCompound != null) {
            power = tagCompound.func_74760_g("power");
        }
        if (power > 1.0E-5f) {
            list.add("You can feel the latent power present in this crystal.");
        } else {
            list.add("This crystal is depleted. Perhaps it still has a future use?");
        }
        if (tagCompound != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            list.add(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(tagCompound.func_74760_g("strength")) + "% " + decimalFormat.format(tagCompound.func_74760_g("efficiency")) + "% " + decimalFormat.format(tagCompound.func_74760_g("purity")) + "%");
            list.add(TextFormatting.YELLOW + "Power left: " + decimalFormat.format(power) + "%");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            probeInfo.text(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(crystal.getStrength()) + "% " + decimalFormat.format(crystal.getEfficiency()) + "% " + decimalFormat.format(crystal.getPurity()) + "%");
            int rfPerTick = crystal.getRfPerTick();
            probeInfo.horizontal().text(TextFormatting.YELLOW + "Power: " + decimalFormat.format(crystal.getPower()) + "% (" + rfPerTick + " RF/t)").progress((int)crystal.getPower(), 100, probeInfo.defaultProgressStyle().suffix("%").width(40).height(10).showText(false).filledColor(-65536).alternateFilledColor(-6750208));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)tileEntity;
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            currenttip.add(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(resonatingCrystalTileEntity.getStrength()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getEfficiency()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getPurity()) + "%");
            currenttip.add(TextFormatting.YELLOW + "Power left: " + decimalFormat.format(tooltipPower) + "% (" + tooltipRFTick + " RF/t)");
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketGetCrystalInfo(tileEntity.func_174877_v()));
            }
        }
        return currenttip;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            TileEntity theCrystalTile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
            ElecCore.tickHandler.registerCall(() -> {
                float forceMultiplier = 1.0f;
                if (theCrystalTile instanceof ResonatingCrystalTileEntity) {
                    ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)theCrystalTile;
                    float explosionStrength = resonatingCrystalTileEntity.getPower() * resonatingCrystalTileEntity.getStrength() / 10000.0f;
                    forceMultiplier = explosionStrength * (RadiationConfiguration.maximumExplosionMultiplier - RadiationConfiguration.minimumExplosionMultiplier) + RadiationConfiguration.minimumExplosionMultiplier;
                    if (forceMultiplier > RadiationConfiguration.absoluteMaximumExplosionMultiplier) {
                        forceMultiplier = RadiationConfiguration.absoluteMaximumExplosionMultiplier;
                    }
                    if (forceMultiplier > 0.001f) {
                        DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
                        DRRadiationManager.RadiationSource source = radiationManager.getOrCreateRadiationSource(new GlobalCoordinate(pos, WorldHelper.getDimID((World)world)));
                        float radiationRadius = DRRadiationManager.calculateRadiationRadius(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getEfficiency(), resonatingCrystalTileEntity.getPurity());
                        float radiationStrength = DRRadiationManager.calculateRadiationStrength(resonatingCrystalTileEntity.getStrength(), resonatingCrystalTileEntity.getPurity());
                        source.update(radiationRadius * RadiationConfiguration.radiationExplosionFactor, radiationStrength / RadiationConfiguration.radiationExplosionFactor, 1000);
                    }
                }
                if (forceMultiplier > 0.001f) {
                    TestExplosion boom = new TestExplosion(world, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), forceMultiplier);
                    boom.explode();
                }
            }, world);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int getGuiID() {
        return -1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING_HORIZ)).func_176745_a() - 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_HORIZ, (Comparable)ResonatingCrystalBlock.getFacingHoriz((int)(meta & 3)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, EMPTY, GENERATED});
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        List drops = super.getDrops(world, pos, metadata, fortune);
        for (ItemStack drop : drops) {
            NBTTagCompound tagCompound;
            if (!drop.func_77942_o() || !(tagCompound = drop.func_77978_p()).func_74764_b("glowing")) continue;
            tagCompound.func_74757_a("glowing", false);
        }
        return drops;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        boolean empty = false;
        boolean generated = false;
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            empty = resonatingCrystalTileEntity.isEmpty();
            generated = resonatingCrystalTileEntity.getPurity() > 30.0f;
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(empty)).func_177226_a((IProperty)GENERATED, (Comparable)Boolean.valueOf(generated));
    }
}

