/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.deepresonance.blocks.laser.InfusingBonus;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mcjty.lib.varia.Logging;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;

public class LaserBonusConfiguration {
    public static final String CATEGORY_LASERBONUS = "lasercatalysts";

    private static String toString(InfusingBonus.Modifier modifier) {
        return modifier.getBonus() + ":" + modifier.getMaxOrMin();
    }

    private static InfusingBonus.Modifier toModifier(String m) {
        float minmax;
        float bonus;
        String[] split = StringUtils.split((String)m, (String)":");
        try {
            bonus = Float.parseFloat(split[0]);
            minmax = Float.parseFloat(split[1]);
        }
        catch (NumberFormatException e) {
            Logging.logError((String)"Error parsing laserbonus config!");
            return InfusingBonus.Modifier.NONE;
        }
        return new InfusingBonus.Modifier(bonus, minmax);
    }

    public static void init(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(CATEGORY_LASERBONUS);
        if (category.isEmpty()) {
            LaserTileEntity.createDefaultInfusionBonusMap();
            for (Map.Entry<String, InfusingBonus> entry : LaserTileEntity.infusingBonusMap.entrySet()) {
                InfusingBonus bonus = entry.getValue();
                cfg.get(CATEGORY_LASERBONUS, entry.getKey() + "_color", bonus.getColor(), "Beam color (1 = blue, 2 = red, 3 = green, 4 = yellow)");
                cfg.get(CATEGORY_LASERBONUS, entry.getKey() + "_purity", LaserBonusConfiguration.toString(bonus.getPurityModifier()), "A percentage:minmax purity bonus to add or subtract to the rcl infuse unit volume");
                cfg.get(CATEGORY_LASERBONUS, entry.getKey() + "_strength", LaserBonusConfiguration.toString(bonus.getStrengthModifier()), "A percentage:minmax strength bonus to add or subtract to the rcl infuse unit volume");
                cfg.get(CATEGORY_LASERBONUS, entry.getKey() + "_efficiency", LaserBonusConfiguration.toString(bonus.getEfficiencyModifier()), "A percentage:minmax efficiency bonus to add or subtract to the rcl infuse unit volume");
            }
        } else {
            LaserTileEntity.infusingBonusMap = new HashMap<String, InfusingBonus>();
            ArrayList<String> items = new ArrayList<String>();
            for (Map.Entry entry : category.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.endsWith("_color")) continue;
                String name = key.substring(0, key.indexOf("_color"));
                Logging.log((String)("Found infusion bonus for: " + name));
                items.add(name);
            }
            for (String name : items) {
                int color = cfg.get(CATEGORY_LASERBONUS, name + "_color", 1, "Beam color (1 = blue, 2 = red, 3 = green, 4 = yellow)").getInt();
                InfusingBonus.Modifier purityModifier = LaserBonusConfiguration.toModifier(cfg.get(CATEGORY_LASERBONUS, name + "_purity", "0:0", "A percentage:minmax purity bonus to add or subtract to the rcl infuse unit volume").getString());
                InfusingBonus.Modifier strengthModifier = LaserBonusConfiguration.toModifier(cfg.get(CATEGORY_LASERBONUS, name + "_strength", "0:0", "A percentage:minmax strength bonus to add or subtract to the rcl infuse unit volume").getString());
                InfusingBonus.Modifier efficiencyModifier = LaserBonusConfiguration.toModifier(cfg.get(CATEGORY_LASERBONUS, name + "_efficiency", "0:0", "A percentage:minmax efficiency bonus to add or subtract to the rcl infuse unit volume").getString());
                LaserTileEntity.infusingBonusMap.put(name, new InfusingBonus(color, purityModifier, strengthModifier, efficiencyModifier));
            }
        }
    }
}

