/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.ore;

import elec332.core.world.WorldHelper;
import java.util.Random;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResonatingPlateBlock
extends Block {
    public ResonatingPlateBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        if (ConfigMachines.PlateBlock.radiationStrength > 0) {
            this.func_149675_a(true);
        }
        this.func_149663_c("deepresonance.resonating_block");
        this.setRegistryName("resonating_block");
        this.func_149647_a(DeepResonance.tabDeepResonance);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (ConfigMachines.PlateBlock.radiationStrength <= 0) {
            return;
        }
        int powered = world.func_175676_y(pos);
        if (powered > 0) {
            GlobalCoordinate thisCoordinate;
            DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
            if (radiationManager.getRadiationSource(thisCoordinate = new GlobalCoordinate(pos, WorldHelper.getDimID((World)world))) == null) {
                Logging.log((String)("Created radiation source with radius " + ConfigMachines.PlateBlock.radiationRadius + " and strength " + ConfigMachines.PlateBlock.radiationStrength));
            }
            DRRadiationManager.RadiationSource radiationSource = radiationManager.getOrCreateRadiationSource(thisCoordinate);
            radiationSource.update(ConfigMachines.PlateBlock.radiationRadius, ConfigMachines.PlateBlock.radiationStrength, ConfigMachines.PlateBlock.radiationTicks);
            radiationManager.save(world);
        }
    }
}

