/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.pedestal;

import elec332.core.world.WorldHelper;
import java.util.Optional;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.collector.EnergyCollectorSetup;
import mcjty.deepresonance.blocks.collector.EnergyCollectorTileEntity;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.pedestal.PedestalContainer;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.InventoryLocator;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.SoundTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class PedestalTileEntity
extends GenericTileEntity
implements DefaultSidedInventory,
ITickable {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, PedestalContainer.factory, 1);
    private int checkCounter = 0;
    private InventoryLocator inventoryLocator = new InventoryLocator();
    private BlockPos cachedLocator = null;
    private static EnumFacing[] directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN};

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 20;
        BlockPos b = this.getCrystalPosition();
        if (this.field_145850_b.func_175623_d(b)) {
            this.placeCrystal();
        } else if (WorldHelper.getBlockAt((IBlockAccess)this.field_145850_b, (BlockPos)b) == ModBlocks.resonatingCrystalBlock) {
            this.checkCrystal();
        }
    }

    public BlockPos getCrystalPosition() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing orientation = BlockTools.getOrientation((int)state.func_177230_c().func_176201_c(state));
        return this.field_174879_c.func_177972_a(orientation);
    }

    public Optional<ResonatingCrystalTileEntity> getCrystal() {
        BlockPos p = this.getCrystalPosition();
        TileEntity t = WorldHelper.getTileAt((IBlockAccess)this.field_145850_b, (BlockPos)p);
        if (t instanceof ResonatingCrystalTileEntity) {
            return Optional.of((ResonatingCrystalTileEntity)t);
        }
        return Optional.empty();
    }

    public boolean crystalPresent() {
        return WorldHelper.getBlockAt((IBlockAccess)this.field_145850_b, (BlockPos)this.getCrystalPosition()) == ModBlocks.resonatingCrystalBlock;
    }

    private void placeCrystal() {
        BlockPos pos = this.getCrystalPosition();
        ItemStack crystalStack = this.inventoryHelper.getStackInSlot(0);
        if (crystalStack != null && crystalStack.field_77994_a > 0 && crystalStack.func_77973_b() instanceof ItemBlock) {
            TileEntity tileEntity;
            ItemBlock itemBlock = (ItemBlock)crystalStack.func_77973_b();
            itemBlock.placeBlockAt(crystalStack, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)), this.field_145850_b, pos, null, 0.0f, 0.0f, 0.0f, itemBlock.func_179223_d().func_176203_a(0));
            this.inventoryHelper.decrStackSize(0, 1);
            SoundTools.playSound((World)this.field_145850_b, (SoundEvent)ModBlocks.resonatingCrystalBlock.func_185467_w().field_185862_o, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
            if (this.findCollector() && (tileEntity = WorldHelper.getTileAt((IBlockAccess)this.field_145850_b, (BlockPos)new BlockPos((Vec3i)this.cachedLocator))) instanceof EnergyCollectorTileEntity) {
                EnergyCollectorTileEntity energyCollectorTileEntity = (EnergyCollectorTileEntity)tileEntity;
                energyCollectorTileEntity.addCrystal(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
    }

    private void checkCrystal() {
        BlockPos p = this.getCrystalPosition();
        Optional<Boolean> powerLow = this.getCrystal().map(tile -> tile.getPower() <= 1.0E-5f);
        if (powerLow.orElse(false).booleanValue()) {
            this.dropCrystal();
        }
    }

    public void dropCrystal() {
        Optional<ResonatingCrystalTileEntity> crystal = this.getCrystal();
        if (!crystal.isPresent()) {
            return;
        }
        ResonatingCrystalTileEntity resonatingCrystalTileEntity = crystal.get();
        BlockPos p = resonatingCrystalTileEntity.func_174877_v();
        ItemStack spentCrystal = new ItemStack((Block)ModBlocks.resonatingCrystalBlock, 1);
        NBTTagCompound tagCompound = new NBTTagCompound();
        resonatingCrystalTileEntity.func_189515_b(tagCompound);
        spentCrystal.func_77982_d(tagCompound);
        this.inventoryLocator.ejectStack(this.field_145850_b, this.func_174877_v(), spentCrystal, this.field_174879_c, directions);
        this.field_145850_b.func_175698_g(p);
        SoundTools.playSound((World)this.field_145850_b, (SoundEvent)ModBlocks.resonatingCrystalBlock.func_185467_w().field_185862_o, (double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)1.0, (double)1.0);
    }

    private boolean findCollector() {
        BlockPos crystalLocation = this.getCrystalPosition();
        if (this.cachedLocator != null) {
            if (WorldHelper.getBlockAt((IBlockAccess)this.field_145850_b, (BlockPos)this.cachedLocator) == EnergyCollectorSetup.energyCollectorBlock) {
                return true;
            }
            this.cachedLocator = null;
        }
        float closestDistance = Float.MAX_VALUE;
        int yy = crystalLocation.func_177956_o();
        int xx = crystalLocation.func_177958_n();
        int zz = crystalLocation.func_177952_p();
        for (int y = yy - ConfigMachines.Collector.maxVerticalCrystalDistance; y <= yy + ConfigMachines.Collector.maxVerticalCrystalDistance; ++y) {
            if (y < 0 || y >= this.field_145850_b.func_72800_K()) continue;
            int maxhordist = ConfigMachines.Collector.maxHorizontalCrystalDistance;
            for (int x = xx - maxhordist; x <= xx + maxhordist; ++x) {
                for (int z = zz - maxhordist; z <= zz + maxhordist; ++z) {
                    double sqdist;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (WorldHelper.getBlockAt((IBlockAccess)this.field_145850_b, (BlockPos)pos) != EnergyCollectorSetup.energyCollectorBlock || !((sqdist = pos.func_177951_i((Vec3i)crystalLocation)) < (double)closestDistance)) continue;
                    closestDistance = (float)sqdist;
                    this.cachedLocator = pos;
                }
            }
        }
        return this.cachedLocator != null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
    }
}

