/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.smelter;

import elec332.core.world.WorldHelper;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.smelter.SmelterBlock;
import mcjty.deepresonance.blocks.smelter.SmelterContainer;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SmelterTileEntity
extends GenericEnergyReceiverTileEntity
implements ITankHook,
DefaultSidedInventory,
ITickable {
    public static final String CMD_GETPROGRESS = "getProgress";
    public static final String CLIENTCMD_GETPROGRESS = "getProgress";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SmelterContainer.factory, 1);
    private int totalProgress = 0;
    private int progress = 0;
    private TileTank lavaTank;
    private TileTank rclTank;
    private boolean checkTanks = true;
    private float finalQuality = 1.0f;
    private float finalPurity = 0.1f;
    private static int progressPercentage = 0;

    public SmelterTileEntity() {
        super(ConfigMachines.Smelter.rfMaximum, ConfigMachines.Smelter.rfPerTick);
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    protected void checkStateServer() {
        if (this.progress > 0) {
            if (this.canWork()) {
                --this.progress;
                this.storage.extractEnergy(ConfigMachines.Smelter.rfPerOre, false);
                if (this.progress == 0) {
                    this.stopSmelting();
                }
            }
        } else {
            boolean newworking;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean oldworking = (Boolean)state.func_177229_b((IProperty)SmelterBlock.WORKING);
            if (this.canWork() && this.validSlot()) {
                this.startSmelting();
                newworking = true;
            } else {
                newworking = false;
            }
            if (newworking != oldworking) {
                state = state.func_177226_a((IProperty)SmelterBlock.WORKING, (Comparable)Boolean.valueOf(newworking));
                this.field_145850_b.func_180501_a(this.func_174877_v(), state, 3);
            }
        }
    }

    public static int getProgressPercentage() {
        return progressPercentage;
    }

    private boolean canWork() {
        if (this.checkTanks) {
            if (this.checkTanks()) {
                this.checkTanks = false;
            } else {
                return false;
            }
        }
        return this.storage.getEnergyStored() >= ConfigMachines.Smelter.rfPerOre;
    }

    private boolean checkTanks() {
        return this.lavaTank != null && this.rclTank != null && this.lavaTank.getTank() != null && this.rclTank.getTank() != null && DRFluidRegistry.getFluidFromStack(this.lavaTank.getFluid()) == FluidRegistry.LAVA && (float)this.lavaTank.getFluidAmount() > (float)this.lavaTank.getCapacity() * 0.25f && this.rclTank.getTank().fill(new FluidStack(DRFluidRegistry.liquidCrystal, ConfigMachines.Smelter.rclPerOre), false) == ConfigMachines.Smelter.rclPerOre;
    }

    private boolean validSlot() {
        return this.inventoryHelper.getStackInSlot(0) != null && this.inventoryHelper.getStackInSlot(0).func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingOreBlock);
    }

    private void startSmelting() {
        this.inventoryHelper.decrStackSize(0, 1);
        float percentage = (float)this.lavaTank.getFluidAmount() / (float)this.lavaTank.getCapacity();
        if (percentage < 0.4f) {
            this.finalQuality = 1.0f - (0.4f - percentage);
            this.finalPurity = 0.1f;
        } else if (percentage > 0.75f) {
            this.finalQuality = -1.0f;
            this.finalPurity = 0.0f;
        } else if (percentage > 0.6f) {
            this.finalQuality = 1.0f - (percentage - 0.6f) * 6.666f;
            this.finalPurity = 0.1f - (percentage - 0.6f) * 0.3f;
        } else {
            this.finalQuality = 1.0f;
            this.finalPurity = 0.1f;
        }
        this.lavaTank.getTank().drain(new FluidStack(FluidRegistry.LAVA, ConfigMachines.Smelter.lavaCost), true);
        this.totalProgress = this.progress = ConfigMachines.Smelter.processTime + (int)((percentage - 0.5f) * (float)ConfigMachines.Smelter.processTime);
    }

    private void stopSmelting() {
        if (this.finalQuality > 0.0f) {
            FluidStack stack = LiquidCrystalFluidTagData.makeLiquidCrystalStack(ConfigMachines.Smelter.rclPerOre, this.finalQuality, this.finalPurity, 0.1f, 0.1f);
            this.rclTank.getTank().fill(stack, true);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("totalProgress", this.totalProgress);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74776_a("finalQuality", this.finalQuality);
        tagCompound.func_74776_a("finalPurity", this.finalPurity);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.totalProgress = tagCompound.func_74762_e("totalProgress");
        this.progress = tagCompound.func_74762_e("progress");
        this.finalQuality = tagCompound.func_74760_g("finalQuality");
        this.finalPurity = tagCompound.func_74760_g("finalPurity");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    @Override
    public void hook(TileTank tank, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            this.lavaTank = tank;
        } else if (this.rclTank == null && this.validRCLTank(tank)) {
            this.rclTank = tank;
        }
        this.checkTanks = true;
    }

    @Override
    public void unHook(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.lavaTank, tank)) {
            this.lavaTank = null;
        } else if (this.tilesEqual(this.rclTank, tank)) {
            this.rclTank = null;
            this.notifyAndMarkDirty();
        }
        this.checkTanks = true;
    }

    @Override
    public void onContentChanged(TileTank tank, EnumFacing direction) {
        if (this.tilesEqual(this.rclTank, tank) && !this.validRCLTank(tank)) {
            this.rclTank = null;
        }
        this.checkTanks = true;
    }

    private boolean validRCLTank(TileTank tank) {
        Fluid fluid = DRFluidRegistry.getFluidFromStack(tank.getFluid());
        return fluid == null || fluid == DRFluidRegistry.liquidCrystal;
    }

    private boolean tilesEqual(TileTank first, TileTank second) {
        return first != null && second != null && first.func_174877_v().equals((Object)second.func_174877_v()) && WorldHelper.getDimID((World)first.func_145831_w()) == WorldHelper.getDimID((World)second.func_145831_w());
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack item, EnumFacing side) {
        if (!this.func_94041_b(index, item)) {
            return false;
        }
        return SmelterContainer.factory.isInputSlot(index) || SmelterContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack item, EnumFacing side) {
        return SmelterContainer.factory.isOutputSlot(index);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.resonatingOreBlock);
    }

    public void requestProgressFromServer() {
        DeepResonance.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketRequestIntegerFromServer("deepresonance", this.field_174879_c, "getProgress", "getProgress", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getProgress".equals(command)) {
            if (this.totalProgress == 0) {
                return 0;
            }
            return (this.totalProgress - this.progress) * 100 / this.totalProgress;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getProgress".equals(command)) {
            progressPercentage = result;
            return true;
        }
        return false;
    }

    protected void notifyAndMarkDirty() {
        if (WorldHelper.chunkLoaded((World)this.field_145850_b, (BlockPos)this.field_174879_c)) {
            this.func_70296_d();
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
        }
    }
}

