/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.boom;

import elec332.core.explosion.Elexplosion;
import elec332.core.world.WorldHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TestExplosion
extends Elexplosion {
    public TestExplosion(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    protected void preExplode() {
        this.damageEntities(this.getRadius(), 4.0f);
    }

    public void explode() {
        if (!this.getWorld().field_72995_K) {
            int x = (int)(-this.getRadius());
            while ((float)x < this.getRadius()) {
                int y = (int)(-this.getRadius());
                while ((float)y < this.getRadius()) {
                    int z = (int)(-this.getRadius());
                    while ((float)z < this.getRadius()) {
                        BlockPos targetPosition = this.getLocation().func_177982_a(x, y, z);
                        double dist = Math.sqrt(this.getLocation().func_177951_i((Vec3i)targetPosition));
                        if (dist < (double)this.getRadius()) {
                            Block block = WorldHelper.getBlockAt((IBlockAccess)this.getWorld(), (BlockPos)targetPosition);
                            IBlockState state = this.getWorld().func_180495_p(targetPosition);
                            if (block != null && !block.isAir(state, (IBlockAccess)this.getWorld(), targetPosition) && block.func_176195_g(state, this.getWorld(), targetPosition) > 0.0f && (dist < (double)(this.getRadius() - 1.0f) || (double)this.getWorld().field_73012_v.nextFloat() > 0.7)) {
                                block.onBlockExploded(this.getWorld(), targetPosition, (Explosion)this);
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    protected void damageEntities(float radius, float power) {
        if (!this.getWorld().field_72995_K) {
            float minRadius = -(radius *= 2.0f) - 1.0f;
            float maxRadius = radius + 1.0f;
            BlockPos minCoord = this.getLocation();
            minCoord.func_177963_a((double)minRadius, (double)minRadius, (double)minRadius);
            BlockPos maxCoord = this.getLocation();
            maxCoord.func_177963_a((double)maxRadius, (double)maxRadius, (double)maxRadius);
            List allEntities = this.getWorld().func_72872_a(EntityLiving.class, new AxisAlignedBB((double)minCoord.func_177958_n(), (double)minCoord.func_177956_o(), (double)minCoord.func_177952_p(), (double)maxCoord.func_177958_n(), (double)maxCoord.func_177956_o(), (double)maxCoord.func_177952_p()));
            for (Object allEntity : allEntities) {
                Entity entity = (Entity)allEntity;
                double distance = entity.func_70011_f((double)this.getLocation().func_177958_n(), (double)this.getLocation().func_177956_o(), (double)this.getLocation().func_177952_p()) / (double)radius;
                if (!(distance <= 1.0)) continue;
                double xDifference = entity.field_70165_t - (double)this.getLocation().func_177958_n();
                double yDifference = entity.field_70163_u - (double)this.getLocation().func_177956_o();
                double zDifference = entity.field_70161_v - (double)this.getLocation().func_177952_p();
                double d1 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
                xDifference /= d1;
                yDifference /= d1;
                zDifference /= d1;
                double density = this.getWorld().func_72842_a(new Vec3d((double)this.getLocation().func_177958_n(), (double)this.getLocation().func_177956_o(), (double)this.getLocation().func_177952_p()), entity.func_174813_aQ());
                double d2 = (1.0 - distance) * density;
                int damage = (int)((d2 * d2 + d2) / 2.0 * 8.0 * (double)power + 1.0);
                entity.field_70159_w += xDifference * d2;
                entity.field_70181_x += yDifference * d2;
                entity.field_70179_y += zDifference * d2;
            }
        }
    }
}

