/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.integration.computers;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.ManagedEnvironment;
import mcjty.deepresonance.blocks.valve.ValveTileEntity;
import mcjty.deepresonance.integration.computers.AbstractOCDriver;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ValveDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("deepresonance_valve", ValveTileEntity.class);
        }

        @Override
        public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((ValveTileEntity)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<ValveTileEntity> {
            public InternalManagedEnvironment(ValveTileEntity tile) {
                super(tile, "deepresonance_valve");
            }

            @Callback(doc="function():number; Get the minimum purity setting")
            public Object[] getMinPurity(Context c, Arguments a) {
                return new Object[]{Float.valueOf(((ValveTileEntity)this.tile).getMinPurity() * 100.0f)};
            }

            @Callback(doc="function(number); Set the minimum purity setting")
            public Object[] setMinPurity(Context c, Arguments a) {
                double newVal = a.checkDouble(0);
                if (newVal < 0.0 || newVal > 100.0) {
                    return new Object[]{false, "Value needs to be between 0 and 100"};
                }
                ((ValveTileEntity)this.tile).setMinPurity((float)newVal / 100.0f);
                ((ValveTileEntity)this.tile).markDirtyClient();
                return new Object[]{true};
            }

            @Callback(doc="function():number; Get the minimum strength setting")
            public Object[] getMinStrength(Context c, Arguments a) {
                return new Object[]{Float.valueOf(((ValveTileEntity)this.tile).getMinStrength() * 100.0f)};
            }

            @Callback(doc="function(number); Set the minimum strength setting")
            public Object[] setMinStrength(Context c, Arguments a) {
                double newVal = a.checkDouble(0);
                if (newVal < 0.0 || newVal > 100.0) {
                    return new Object[]{false, "Value needs to be between 0 and 100"};
                }
                ((ValveTileEntity)this.tile).setMinStrength((float)newVal / 100.0f);
                ((ValveTileEntity)this.tile).markDirtyClient();
                return new Object[]{true};
            }

            @Callback(doc="function():number; Get the minimum efficiency setting")
            public Object[] getMinEfficiency(Context c, Arguments a) {
                return new Object[]{Float.valueOf(((ValveTileEntity)this.tile).getMinEfficiency() * 100.0f)};
            }

            @Callback(doc="function(number); Set the minimum efficiency setting")
            public Object[] setMinEfficiency(Context c, Arguments a) {
                double newVal = a.checkDouble(0);
                if (newVal < 0.0 || newVal > 100.0) {
                    return new Object[]{false, "Value needs to be between 0 and 100"};
                }
                ((ValveTileEntity)this.tile).setMinEfficiency((float)newVal / 100.0f);
                ((ValveTileEntity)this.tile).markDirtyClient();
                return new Object[]{true};
            }

            @Callback(doc="function():number; Get the maximum amount of fluid")
            public Object[] getMaxMb(Context c, Arguments a) {
                return new Object[]{((ValveTileEntity)this.tile).getMaxMb()};
            }

            @Callback(doc="function(number); Set the maximum amount of fluid")
            public Object[] setMaxMb(Context c, Arguments a) {
                double newVal = a.checkDouble(0);
                if (newVal < 0.0) {
                    return new Object[]{false, "Value needs to be greater than or equal to 0"};
                }
                ((ValveTileEntity)this.tile).setMaxMb((int)newVal);
                ((ValveTileEntity)this.tile).markDirtyClient();
                return new Object[]{true};
            }

            @Callback(doc="function():string; Get the current redstone mode. One of \"Ignored\", \"Off\" and \"On\"")
            public Object[] getRedstoneMode(Context c, Arguments a) {
                return new Object[]{((ValveTileEntity)this.tile).getRSMode().getDescription()};
            }

            @Callback(doc="function(string); Set the redstone mode. One of \"Ignored\", \"Off\" and \"On\"")
            public Object[] setRedstoneMode(Context c, Arguments a) {
                String newVal = a.checkString(0);
                RedstoneMode rsMode = RedstoneMode.getMode((String)newVal);
                if (rsMode != null) {
                    ((ValveTileEntity)this.tile).setRSMode(rsMode);
                    ((ValveTileEntity)this.tile).markDirtyClient();
                    return new Object[]{true};
                }
                return new Object[]{false, "Not a valid redstone mode. Needs to be one of \"Ignored\", \"Off\" and \"On\""};
            }

            @Override
            public int priority() {
                return 4;
            }
        }
    }
}

