/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.items.RadiationMonitorItem;
import mcjty.deepresonance.network.PacketReturnRadiation;
import mcjty.lib.varia.GlobalCoordinate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetRadiationLevel
implements IMessage {
    private GlobalCoordinate coordinate;

    public void fromBytes(ByteBuf buf) {
        int dim = buf.readInt();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.coordinate = new GlobalCoordinate(new BlockPos(x, y, z), dim);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.coordinate.getDimension());
        buf.writeInt(this.coordinate.getCoordinate().func_177958_n());
        buf.writeInt(this.coordinate.getCoordinate().func_177956_o());
        buf.writeInt(this.coordinate.getCoordinate().func_177952_p());
    }

    public PacketGetRadiationLevel() {
    }

    public PacketGetRadiationLevel(GlobalCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public static class Handler
    implements IMessageHandler<PacketGetRadiationLevel, IMessage> {
        public IMessage onMessage(PacketGetRadiationLevel message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetRadiationLevel message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            float strength = RadiationMonitorItem.calculateRadiationStrength(world, message.coordinate);
            PacketReturnRadiation packet = new PacketReturnRadiation(strength);
            DeepResonance.networkHandler.getNetworkWrapper().sendTo((IMessage)packet, ctx.getServerHandler().field_147369_b);
        }
    }
}

