/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.varia;

import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class FluidTankWrapper
implements IFluidHandler,
IFluidTank {
    private IFluidTankProperties[] properties;

    public static FluidTankWrapper of(final IFluidTank tank) {
        return new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return tank;
            }
        };
    }

    public FluidTankWrapper() {
        Properties prop = new Properties(this);
        this.properties = new IFluidTankProperties[]{prop};
    }

    protected abstract IFluidTank getTank();

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        return this.getTank().fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack f = this.getTank().getFluid();
        if (!this.canDrainFluidType(f) || resource == null || f == null || resource.getFluid() != f.getFluid()) {
            return null;
        }
        return this.getTank().drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrainFluidType(this.getTank().getFluid())) {
            return null;
        }
        return this.getTank().drain(maxDrain, doDrain);
    }

    @Nullable
    public FluidStack getFluid() {
        FluidStack tankStack = this.getTank().getFluid();
        return tankStack == null ? null : tankStack.copy();
    }

    public int getFluidAmount() {
        return this.getTank().getFluidAmount();
    }

    public int getCapacity() {
        return this.getTank().getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.getTank().getInfo();
    }

    protected boolean canFill() {
        return true;
    }

    protected boolean canDrain() {
        return true;
    }

    protected boolean canFillFluidType(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        FluidStack f = this.getTank().getFluid();
        if (f == null) {
            return this.canFillFluidTypeInternal(fluidStack);
        }
        return f.getFluid() == fluidStack.getFluid();
    }

    protected boolean canFillFluidTypeInternal(FluidStack fluidStack) {
        return this.canFill();
    }

    protected boolean canDrainFluidType(FluidStack fluidStack) {
        return fluidStack != null && this.canDrain();
    }

    private class Properties
    implements IFluidTankProperties {
        private final FluidTankWrapper tank;

        private Properties(FluidTankWrapper tank) {
            this.tank = tank;
        }

        @Nullable
        public FluidStack getContents() {
            FluidStack stack = this.tank.getTank().getFluid();
            return stack == null ? null : stack.copy();
        }

        public int getCapacity() {
            return this.tank.getTank().getCapacity();
        }

        public boolean canFill() {
            return this.tank.canFill();
        }

        public boolean canDrain() {
            return this.tank.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return this.tank.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.tank.canDrainFluidType(fluidStack);
        }
    }
}

