/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public final class CraftingHandler {
    private static HashMap<String, Field> knownCraftingContainer;
    private static HashSet<String> notCraftingContainer;
    private static int previousNumberOfCraft;
    private static int delayTimer;
    private static int recipeIndex;

    public static void enableGuessing() {
        knownCraftingContainer = new HashMap();
        notCraftingContainer = new HashSet();
    }

    public static int getRecipeIndex() {
        return recipeIndex;
    }

    public static void setRecipeIndex(int id) {
        if (id >= 0) {
            recipeIndex = id;
        }
    }

    public static InventoryCrafting getCraftingMatrix(Container container) {
        String name;
        if (container == null) {
            return null;
        }
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75181_e;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75162_e;
        }
        if (notCraftingContainer != null && !notCraftingContainer.contains(name = container.getClass().getName())) {
            Field f = knownCraftingContainer.get(name);
            if (f == null) {
                for (Field field : container.getClass().getDeclaredFields()) {
                    if (field == null) continue;
                    try {
                        field.setAccessible(true);
                        Object craft = field.get(container);
                        if (!(craft instanceof InventoryCrafting)) continue;
                        knownCraftingContainer.put(name, field);
                        return (InventoryCrafting)craft;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                notCraftingContainer.add(name);
            } else {
                try {
                    return (InventoryCrafting)f.get(container);
                }
                catch (Exception ref) {
                    knownCraftingContainer.put(name, null);
                }
            }
        }
        return null;
    }

    public static ItemStack findNextMatchingRecipe(InventoryCrafting craft, World world) {
        recipeIndex = recipeIndex == Integer.MAX_VALUE ? 0 : ++recipeIndex;
        return CraftingHandler.findMatchingRecipe(craft, world);
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting craft, World world) {
        if (CraftingManager.func_77594_a().func_82787_a(craft, world) != null) {
            List<ItemStack> result = CraftingHandler.getCraftResult(craft, world);
            if (result.size() == 0) {
                return null;
            }
            if (recipeIndex < 0) {
                int j1 = -recipeIndex;
                j1 %= result.size();
                j1 = result.size() - j1;
                if (j1 == result.size()) {
                    j1 = 0;
                }
                return result.get(j1);
            }
            return result.get(recipeIndex % result.size());
        }
        return null;
    }

    public static List<ItemStack> getCraftResult(InventoryCrafting craft, World world) {
        Iterator recipes = CraftingManager.func_77594_a().func_77592_b().iterator();
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        while (recipes.hasNext()) {
            IRecipe irecipe = (IRecipe)recipes.next();
            if (!irecipe.func_77569_a(craft, world)) continue;
            arraylist.add(irecipe.func_77572_b(craft));
        }
        return arraylist;
    }

    public static IInventory getResultSlot(Container container, int size) {
        if (container == null) {
            return null;
        }
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75179_f;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75160_f;
        }
        if (notCraftingContainer != null) {
            for (Field field : container.getClass().getDeclaredFields()) {
                if (field == null) continue;
                try {
                    field.setAccessible(true);
                    Object result = field.get(container);
                    if (result instanceof IInventory && ((IInventory)result).func_70302_i_() == size) {
                        return (IInventory)result;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static int getNumberOfCraft(Container container, World world) {
        if (delayTimer > 20) {
            delayTimer = 0;
            InventoryCrafting craft = CraftingHandler.getCraftingMatrix(container);
            previousNumberOfCraft = craft != null ? CraftingHandler.getCraftResult(craft, world).size() : 0;
        } else {
            ++delayTimer;
        }
        return previousNumberOfCraft;
    }

    static {
        delayTimer = 10;
    }
}

