/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crazypants.enderio.EnderIO;
import crazypants.enderio.capability.Callback;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.CapturedMob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Filters {
    public static final Callback<ItemStack> NO_CALLBACK = new Callback<ItemStack>(){

        @Override
        public final void onChange(@Nullable ItemStack oldStack, @Nullable ItemStack newStack) {
        }
    };
    public static final Predicate<ItemStack> ALWAYS_TRUE = Predicates.alwaysTrue();
    public static final Predicate<ItemStack> ALWAYS_FALSE = Predicates.alwaysFalse();
    public static final Predicate<ItemStack> ONLY_STACKABLE = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77985_e();
        }
    };
    public static final Predicate<ItemStack> ONLY_PAINTABLE = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return Block.func_149634_a((Item)input.func_77973_b()) instanceof IPaintable;
        }
    };
    public static final Predicate<ItemStack> ONLY_SOUL_VIALS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == EnderIO.itemSoulVessel;
        }
    };
    public static final Predicate<ItemStack> ONLY_FILLED_SOUL_VIALS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == EnderIO.itemSoulVessel && CapturedMob.containsSoul(input);
        }
    };
    public static final Predicate<ItemStack> ONLY_GRINDING_BALLS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return SagMillRecipeManager.getInstance().isValidSagBall(input);
        }
    };

    private Filters() {
    }

    public static abstract class PredicateItemStack
    implements Predicate<ItemStack> {
        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }

        public boolean apply(@Nullable ItemStack input) {
            return input != null && this.doApply(input);
        }

        public abstract boolean doApply(@Nonnull ItemStack var1);
    }
}

