/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorDataItem;
import crazypants.enderio.capacitor.NBTCapacitorData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CapacitorHelper {
    private CapacitorHelper() {
    }

    public static ICapacitorData getCapacitorDataFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        ICapacitorData capData = CapacitorHelper.getNBTCapacitorDataFromItemStack(stack, item);
        if (capData != null) {
            return capData;
        }
        if (item instanceof ICapacitorDataItem) {
            return ((ICapacitorDataItem)item).getCapacitorData(stack);
        }
        return null;
    }

    protected static ICapacitorData getNBTCapacitorDataFromItemStack(ItemStack stack, Item item) {
        NBTTagCompound nbtRoot = stack.func_77978_p();
        if (nbtRoot == null) {
            return null;
        }
        if (!nbtRoot.func_150297_b("eiocap", 10)) {
            return null;
        }
        NBTTagCompound nbtTag = nbtRoot.func_74775_l("eiocap");
        if (!nbtTag.func_150297_b("level", 99)) {
            return null;
        }
        int capLevel = nbtTag.func_74762_e("level");
        if (capLevel <= 0 || capLevel > 99) {
            return null;
        }
        return new NBTCapacitorData(item.func_77667_c(stack), capLevel, nbtTag);
    }

    public static ItemStack addCapData(ItemStack stack, SetType setType, CapacitorKey key, float value) {
        NBTTagCompound root = stack.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            stack.func_77982_d(root);
        }
        NBTTagCompound tag = root.func_74775_l("eiocap");
        root.func_74782_a("eiocap", (NBTBase)tag);
        switch (setType) {
            case LEVEL: {
                tag.func_74768_a("level", (int)value);
                break;
            }
            case NAME: {
                tag.func_74776_a(key.getName(), value);
                break;
            }
            case OWNER_TYPE: {
                NBTTagCompound subtag = tag.func_74775_l(key.getOwner().getUnlocalisedName());
                subtag.func_74776_a(key.getValueType().getName(), value);
                break;
            }
            case TYPE: {
                tag.func_74776_a(key.getValueType().getName(), value);
            }
        }
        return stack;
    }

    public static enum SetType {
        LEVEL,
        NAME,
        OWNER_TYPE,
        TYPE;

    }
}

