/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import crazypants.enderio.EnderIO;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import net.minecraft.nbt.NBTTagCompound;

public class NBTCapacitorData
implements ICapacitorData {
    private final String unlocalizedName;
    private final int baselevel;
    private final NBTTagCompound tag;

    public NBTCapacitorData(String unlocalizedName, int baselevel, NBTTagCompound tag) {
        this.unlocalizedName = unlocalizedName;
        this.baselevel = baselevel;
        this.tag = tag;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public float getUnscaledValue(ICapacitorKey key) {
        NBTTagCompound subtag;
        if (this.tag.func_150297_b(key.getName(), 99)) {
            return this.tag.func_74760_g(key.getName());
        }
        if (this.tag.func_150297_b(key.getOwner().getUnlocalisedName(), 10) && (subtag = this.tag.func_74775_l(key.getOwner().getUnlocalisedName())).func_150297_b(key.getValueType().getName(), 99)) {
            return subtag.func_74760_g(key.getValueType().getName());
        }
        if (this.tag.func_150297_b(key.getValueType().getName(), 99)) {
            return this.tag.func_74760_g(key.getValueType().getName());
        }
        return this.baselevel;
    }

    @Override
    public String getLocalizedName() {
        return EnderIO.lang.localizeExact(this.unlocalizedName + ".name");
    }

    @Override
    public int getBaseLevel() {
        return this.baselevel;
    }
}

