/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class Offsets {
    private static Map<OffsetKey, Offset> OFFSETS = new HashMap<OffsetKey, Offset>();

    public static Offset get(Class<? extends IConduit> type, EnumFacing dir) {
        Offset res = OFFSETS.get(Offsets.key(type, Offsets.getAxisForDir(dir)));
        if (res == null) {
            res = Offset.NONE;
        }
        return res;
    }

    public static OffsetKey key(Class<? extends IConduit> type, Axis axis) {
        return new OffsetKey(type, axis);
    }

    public static Axis getAxisForDir(EnumFacing dir) {
        if (dir == null) {
            return Axis.NONE;
        }
        if (dir == EnumFacing.EAST || dir == EnumFacing.WEST) {
            return Axis.X;
        }
        if (dir == EnumFacing.UP || dir == EnumFacing.DOWN) {
            return Axis.Y;
        }
        if (dir == EnumFacing.NORTH || dir == EnumFacing.SOUTH) {
            return Axis.Z;
        }
        return Axis.NONE;
    }

    static {
        OFFSETS.put(Offsets.key(IRedstoneConduit.class, Axis.NONE), Offset.UP);
        OFFSETS.put(Offsets.key(IRedstoneConduit.class, Axis.X), Offset.UP);
        OFFSETS.put(Offsets.key(IRedstoneConduit.class, Axis.Y), Offset.NORTH);
        OFFSETS.put(Offsets.key(IRedstoneConduit.class, Axis.Z), Offset.UP);
        OFFSETS.put(Offsets.key(IPowerConduit.class, Axis.NONE), Offset.DOWN);
        OFFSETS.put(Offsets.key(IPowerConduit.class, Axis.X), Offset.DOWN);
        OFFSETS.put(Offsets.key(IPowerConduit.class, Axis.Y), Offset.SOUTH);
        OFFSETS.put(Offsets.key(IPowerConduit.class, Axis.Z), Offset.DOWN);
        OFFSETS.put(Offsets.key(ILiquidConduit.class, Axis.NONE), Offset.WEST);
        OFFSETS.put(Offsets.key(ILiquidConduit.class, Axis.X), Offset.NORTH);
        OFFSETS.put(Offsets.key(ILiquidConduit.class, Axis.Y), Offset.WEST);
        OFFSETS.put(Offsets.key(ILiquidConduit.class, Axis.Z), Offset.WEST);
        OFFSETS.put(Offsets.key(IItemConduit.class, Axis.NONE), Offset.EAST);
        OFFSETS.put(Offsets.key(IItemConduit.class, Axis.X), Offset.SOUTH);
        OFFSETS.put(Offsets.key(IItemConduit.class, Axis.Y), Offset.EAST);
        OFFSETS.put(Offsets.key(IItemConduit.class, Axis.Z), Offset.EAST);
        OFFSETS.put(Offsets.key(IOCConduit.class, Axis.NONE), Offset.NORTH_DOWN);
        OFFSETS.put(Offsets.key(IOCConduit.class, Axis.X), Offset.NORTH_DOWN);
        OFFSETS.put(Offsets.key(IOCConduit.class, Axis.Y), Offset.SOUTH_WEST);
        OFFSETS.put(Offsets.key(IOCConduit.class, Axis.Z), Offset.WEST_DOWN);
    }

    public static class OffsetKey {
        String typeName;
        Axis axis;

        private OffsetKey(Class<? extends IConduit> type, Axis axis) {
            this.typeName = type.getCanonicalName();
            this.axis = axis;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.axis == null ? 0 : this.axis.hashCode());
            result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OffsetKey other = (OffsetKey)obj;
            if (this.axis != other.axis) {
                return false;
            }
            return !(this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName));
        }

        public String toString() {
            return "OffsetKey [typeName=" + this.typeName + ", axis=" + (Object)((Object)this.axis) + "]";
        }
    }

    public static enum Axis {
        NONE,
        X,
        Y,
        Z;

    }
}

