/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum FuzzyMode {
    DISABLED{

        @Override
        boolean compare(ItemStack stack) {
            return false;
        }
    }
    ,
    FUZZY_25{

        @Override
        boolean compare(ItemStack stack) {
            return FuzzyMode.compareQuarter(stack, 1);
        }
    }
    ,
    FUZZY_50{

        @Override
        boolean compare(ItemStack stack) {
            return FuzzyMode.compareQuarter(stack, 2);
        }
    }
    ,
    FUZZY_75{

        @Override
        boolean compare(ItemStack stack) {
            return FuzzyMode.compareQuarter(stack, 3);
        }
    }
    ,
    FUZZY_99{

        @Override
        boolean compare(ItemStack stack) {
            return stack.func_77952_i() >= 1;
        }
    };


    abstract boolean compare(ItemStack var1);

    private static boolean compareQuarter(ItemStack stack, int ratio) {
        return stack.func_77952_i() * 4 >= stack.func_77958_k() * ratio;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        DISABLED(DISABLED, IconEIO.FILTER_FUZZY_DISABLED),
        FUZZY_25(FUZZY_25, IconEIO.FILTER_FUZZY_25),
        FUZZY_50(FUZZY_50, IconEIO.FILTER_FUZZY_50),
        FUZZY_75(FUZZY_75, IconEIO.FILTER_FUZZY_75),
        FUZZY_99(FUZZY_99, IconEIO.FILTER_FUZZY_99);

        private final FuzzyMode mode;
        private final IWidgetIcon icon;

        private IconHolder(FuzzyMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
        }

        public IWidgetIcon getIcon() {
            return this.icon;
        }

        public List<String> getTooltipLines() {
            return Collections.singletonList(EnderIO.lang.localize("gui.conduit.item.fuzzy.".concat(this.name().toLowerCase(Locale.US))));
        }

        public FuzzyMode getMode() {
            return this.mode;
        }

        public static IconHolder getFromMode(FuzzyMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return DISABLED;
        }
    }
}

