/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.oc;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.oc.OCConduitNetwork;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.render.registry.TextureRegistry;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OCConduit
extends AbstractConduit
implements IOCConduit,
IConduitComponent {
    protected OCConduitNetwork network;
    private final Map<EnumFacing, DyeColor> signalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private static final TextureRegistry.TextureSupplier coreTextureS = TextureRegistry.registerTexture("blocks/ocConduitCore");
    private static final TextureRegistry.TextureSupplier coreTextureA = TextureRegistry.registerTexture("blocks/ocConduitCoreAnim");
    private static final TextureRegistry.TextureSupplier longTextureS = TextureRegistry.registerTexture("blocks/ocConduit");
    private static final TextureRegistry.TextureSupplier longTextureA = TextureRegistry.registerTexture("blocks/ocConduitAnim");

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
    }

    public OCConduit() {
    }

    public OCConduit(int meta) {
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        this.setSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("signalColor")]);
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("signalColor", (short)this.getSignalColor(dir).ordinal());
    }

    @Override
    public DyeColor getSignalColor(EnumFacing dir) {
        DyeColor res = this.signalColors.get(dir);
        if (res == null) {
            return DyeColor.SILVER;
        }
        return res;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IOCConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.signalColors.size() >= 0) {
            byte[] modes = new byte[6];
            int i = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                DyeColor col = this.signalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.signalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.values()) {
                if (cols[i] >= 0) {
                    this.signalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
    }

    @Override
    public void setSignalColor(EnumFacing dir, DyeColor col) {
        if (this.signalColors.get(dir) == col) {
            return;
        }
        this.disconnectNode(dir);
        this.signalColors.put(dir, col);
        this.addMissingNodeConnections();
        this.setClientStateDirty();
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IOCConduit.class;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemOCConduit, 1, 0);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            for (EnumFacing dir : this.getExternalConnections()) {
                this.disconnectNode(dir);
            }
        }
        this.network = (OCConduitNetwork)network;
        this.addMissingNodeConnections();
        return true;
    }

    @Override
    public boolean shouldMirrorTexture() {
        return !Config.enableOCConduitsAnimatedTexture;
    }

    private static String prettyNode(Node o) {
        String at = "";
        Environment host = o.host();
        if (host instanceof TileEntity) {
            BlockCoord bc = new BlockCoord((TileEntity)host);
            at = " at " + bc.x + "/" + bc.y + "/" + bc.z;
        }
        return host.getClass().getName().replaceFirst("^.*\\.", "") + at;
    }

    private static TextFormatting dye2chat(DyeColor dyeColor) {
        switch (dyeColor) {
            case BLACK: {
                return TextFormatting.BLACK;
            }
            case BLUE: {
                return TextFormatting.DARK_BLUE;
            }
            case BROWN: {
                return TextFormatting.DARK_RED;
            }
            case CYAN: {
                return TextFormatting.DARK_AQUA;
            }
            case GRAY: {
                return TextFormatting.DARK_GRAY;
            }
            case GREEN: {
                return TextFormatting.DARK_GREEN;
            }
            case LIGHT_BLUE: {
                return TextFormatting.BLUE;
            }
            case LIME: {
                return TextFormatting.GREEN;
            }
            case MAGENTA: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case ORANGE: {
                return TextFormatting.GOLD;
            }
            case PINK: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case PURPLE: {
                return TextFormatting.DARK_PURPLE;
            }
            case RED: {
                return TextFormatting.RED;
            }
            case SILVER: {
                return TextFormatting.GRAY;
            }
            case WHITE: {
                return TextFormatting.WHITE;
            }
            case YELLOW: {
                return TextFormatting.YELLOW;
            }
        }
        return null;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
        if (col != null && res.component != null) {
            this.setSignalColor(res.component.dir, col);
            return true;
        }
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            if (!player.field_70170_p.field_72995_K) {
                BlockCoord bc = this.getLocation();
                if (this.network != null) {
                    boolean noconnections = true;
                    for (DyeColor color : DyeColor.values()) {
                        if (!this.node(color).neighbors().iterator().hasNext()) continue;
                        noconnections = false;
                        TextComponentString coltxt = new TextComponentString(color.getLocalisedName());
                        coltxt.func_150256_b().func_150238_a(OCConduit.dye2chat(color));
                        TextComponentString chantxt = new TextComponentString("Channel ");
                        chantxt.func_150257_a((ITextComponent)coltxt);
                        chantxt.func_150258_a(" at " + bc.x + "/" + bc.y + "/" + bc.z);
                        player.func_145747_a((ITextComponent)chantxt);
                        for (Node other : this.node(color).neighbors()) {
                            player.func_145747_a((ITextComponent)new TextComponentString("  Connected to: " + OCConduit.prettyNode(other)));
                        }
                    }
                    if (noconnections) {
                        player.func_145747_a((ITextComponent)new TextComponentString("No connections at " + bc.x + "/" + bc.y + "/" + bc.z));
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("No network at " + bc.x + "/" + bc.y + "/" + bc.z));
                }
            }
            return true;
        }
        if (ToolUtil.isToolEquipped(player, hand) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
            EnumFacing connDir = res.component.dir;
            EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
            if (all != null && this.containsExternalConnection(connDir)) {
                for (RaytraceResult rtr : all) {
                    if (rtr == null || rtr.component == null || !"ColorController".equals(rtr.component.data)) continue;
                    this.setSignalColor(connDir, DyeColor.getNext((DyeColor)this.getSignalColor(connDir)));
                    return true;
                }
            }
            if (connDir == null || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                return ConduitUtil.joinConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                this.addMissingNodeConnections();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setConnectionMode(EnumFacing dir, ConnectionMode mode) {
        if (mode == ConnectionMode.DISABLED) {
            this.disconnectNode(dir);
        }
        super.setConnectionMode(dir, mode);
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.addMissingNodeConnections();
    }

    private void addMissingNodeConnections() {
        BlockCoord loc = this.getLocation();
        if (loc != null && this.network != null) {
            World world = this.getBundle().getBundleWorldObj();
            EnumSet<EnumFacing> conns = this.getConnections();
            for (DyeColor color : DyeColor.values()) {
                HashSet<Node> should = new HashSet<Node>();
                for (EnumFacing direction : conns) {
                    if (this.getSignalColor(direction) != color) continue;
                    TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
                    Node other = null;
                    if (te instanceof SidedEnvironment) {
                        other = ((SidedEnvironment)te).sidedNode(direction.func_176734_d());
                    } else if (te instanceof Environment) {
                        other = ((Environment)te).node();
                    }
                    if (other == null || other == this.node(color)) continue;
                    should.add(other);
                }
                for (Node other : should) {
                    if (this.node(color).isNeighborOf(other)) continue;
                    this.node(color).connect(other);
                }
            }
        }
    }

    private void disconnectNode(EnumFacing direction) {
        World world = this.getBundle().getBundleWorldObj();
        TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
        Node other = null;
        if (te instanceof SidedEnvironment) {
            other = ((SidedEnvironment)te).sidedNode(direction.func_176734_d());
        } else if (te instanceof Environment) {
            other = ((Environment)te).node();
        }
        if (other != null) {
            this.disconnectNode(other, this.getSignalColor(direction));
        }
    }

    private void disconnectNode(Node other, DyeColor color) {
        if (other == this.node(color)) {
            return;
        }
        Environment otherHost = other.host();
        if (otherHost instanceof OCConduitNetwork && otherHost != this.network) {
            this.node(color).disconnect(other);
            return;
        }
        World world = this.getBundle().getBundleWorldObj();
        EnumSet<EnumFacing> conns = this.getConnections();
        ArrayList<Object> toCheck = new ArrayList<Object>();
        if (otherHost instanceof TileEntity) {
            TileEntity otherTe = (TileEntity)otherHost;
            toCheck.add(otherTe);
        } else {
            for (EnumFacing direction : conns) {
                if (this.getSignalColor(direction) != color) continue;
                TileEntity tileEntity = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)world);
                Node other2 = null;
                if (tileEntity instanceof SidedEnvironment) {
                    other2 = ((SidedEnvironment)tileEntity).sidedNode(direction.func_176734_d());
                } else if (tileEntity instanceof Environment) {
                    other2 = ((Environment)tileEntity).node();
                }
                if (other2 != other) continue;
                toCheck.add(tileEntity);
            }
        }
        boolean stayConnected = false;
        for (TileEntity tileEntity : toCheck) {
            for (EnumFacing direction : EnumFacing.values()) {
                BlockCoord otherPos;
                BlockCoord connTo;
                if (stayConnected) continue;
                boolean checkThisSide = true;
                if (otherHost instanceof SidedEnvironment) {
                    boolean bl = checkThisSide = ((SidedEnvironment)otherHost).sidedNode(direction) != null;
                }
                if (!checkThisSide || (connTo = (otherPos = new BlockCoord(tileEntity)).getLocation(direction)).equals((Object)this.getLocation())) continue;
                TileEntity connToTe = connTo.getTileEntity((IBlockAccess)world);
                if (connToTe instanceof SidedEnvironment) {
                    stayConnected = ((SidedEnvironment)connToTe).sidedNode(direction.func_176734_d()) == this.node(color);
                    continue;
                }
                if (!(connToTe instanceof Environment)) continue;
                stayConnected = ((Environment)connToTe).node() == this.node(color);
            }
        }
        if (!stayConnected) {
            this.node(color).disconnect(other);
        }
    }

    public EnumSet<EnumFacing> getConnections() {
        EnumSet<EnumFacing> cons = EnumSet.noneOf(EnumFacing.class);
        cons.addAll(this.getConduitConnections());
        for (EnumFacing dir : this.getExternalConnections()) {
            if (this.getConnectionMode(dir) == ConnectionMode.DISABLED) continue;
            cons.add(dir);
        }
        return cons;
    }

    @Override
    public ConnectionMode getNextConnectionMode(EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(EnumFacing dir) {
        return this.getNextConnectionMode(dir);
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreConnectionMode) {
        TileEntity te = this.getLocation().getLocation(direction).getTileEntity((IBlockAccess)this.getBundle().getBundleWorldObj());
        if (te instanceof SidedEnvironment) {
            if (this.getBundle().getBundleWorldObj().field_72995_K) {
                return ((SidedEnvironment)te).canConnect(direction.func_176734_d());
            }
            return ((SidedEnvironment)te).sidedNode(direction.func_176734_d()) != null;
        }
        return te instanceof Environment;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node node() {
        return this.network != null ? this.network.node(DyeColor.SILVER) : null;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node node(DyeColor subnet) {
        return this.network != null ? this.network.node(subnet) : null;
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onConnect(Node node) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onDisconnect(Node node) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public void onMessage(Message message) {
    }

    @Optional.Method(modid="OpenComputersAPI|Network")
    public Node sidedNode(EnumFacing side) {
        return this.getConnections().contains(side) ? this.node(this.getSignalColor(side)) : null;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="OpenComputersAPI|Network")
    public boolean canConnect(EnumFacing side) {
        return this.getConnections().contains(side);
    }

    @Override
    public void invalidate() {
    }

    @Override
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (Config.enableOCConduitsAnimatedTexture) {
            if (component.dir == null) {
                return coreTextureA.get(TextureAtlasSprite.class);
            }
            return longTextureA.get(TextureAtlasSprite.class);
        }
        if (component.dir == null) {
            return coreTextureS.get(TextureAtlasSprite.class);
        }
        return longTextureS.get(TextureAtlasSprite.class);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.signalColors);
    }
}

