/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.config.recipes.xml.Item;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Smelting
extends AbstractCrafting {
    private Float exp;
    private Item input;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.exp == null) {
                if (this.valid) {
                    this.exp = Float.valueOf(FurnaceRecipes.func_77602_a().func_151398_b(this.getOutput().getItemStack()));
                }
            } else {
                if (this.exp.floatValue() < 0.0f) {
                    throw new InvalidRecipeConfigException("Invalid negative value for 'exp'");
                }
                if (this.exp.floatValue() > 1.0f) {
                    throw new InvalidRecipeConfigException("Invalid value for 'exp', above 100%");
                }
            }
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            this.valid = this.valid && this.input.isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <crafting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.enforceValidity();
    }

    @Override
    public void register() {
        if (this.isValid() && this.isActive()) {
            GameRegistry.addSmelting((ItemStack)this.input.getItemStack(), (ItemStack)this.getOutput().getItemStack(), (float)this.exp.floatValue());
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("exp".equals(name)) {
            this.exp = Float.valueOf(Float.parseFloat(value));
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = factory.read(new Item(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

