/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.integration.jei.BaseRecipeHandler;
import crazypants.enderio.machine.generator.combustion.GuiCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CombustionRecipeCategory
extends BlankRecipeCategory<CombustionRecipeWrapper> {
    @Nonnull
    public static final String UID = "CombustionGenerator";
    static int xOff = 25;
    static int yOff = 7;
    static int xSize = 136;
    @Nonnull
    private final IDrawable background;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CombustionRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<CombustionRecipeWrapper>(CombustionRecipeWrapper.class, UID)});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockCombustionGenerator, 1, 0), new String[]{UID});
        registry.addRecipeClickArea(GuiCombustionGenerator.class, 155, 42, 16, 16, new String[]{UID});
        long start = System.nanoTime();
        Map fluids = FluidRegistry.getRegisteredFluids();
        ArrayList<CombustionRecipeWrapper> result = new ArrayList<CombustionRecipeWrapper>();
        for (Fluid fluid1 : fluids.values()) {
            IFluidCoolant coolant = FluidFuelRegister.instance.getCoolant(fluid1);
            if (coolant == null) continue;
            for (Fluid fluid2 : fluids.values()) {
                IFluidFuel fuel = FluidFuelRegister.instance.getFuel(fluid2);
                if (fuel == null) continue;
                result.add(new CombustionRecipeWrapper(new FluidStack(fluid1, 1000), new FluidStack(fluid2, 1000), TileCombustionGenerator.getNumTicksPerMbCoolant(coolant, fuel), TileCombustionGenerator.getNumTicksPerMbFuel(fuel), fuel.getPowerPerCycle()));
            }
        }
        long end = System.nanoTime();
        registry.addRecipes(result);
        Log.info(String.format("TankRecipeCategory: Added %d combustion generator recipes to JEI in %.3f seconds.", result.size(), (double)(end - start) / 1.0E9));
    }

    public CombustionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("combustionGen");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, xSize, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return EnderIO.blockCombustionGenerator.func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CombustionRecipeWrapper recipeWrapper) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, false, 114 - xOff, 21 - yOff, 15, 47, 1000, false, null);
        fluidStacks.init(1, false, 48 - xOff, 21 - yOff, 15, 47, 1000, false, null);
        fluidStacks.set(0, recipeWrapper.fluidCoolant);
        fluidStacks.set(1, recipeWrapper.fluidFuel);
    }

    public static class CombustionRecipeWrapper
    extends BlankRecipeWrapper {
        private final FluidStack fluidCoolant;
        private final FluidStack fluidFuel;
        private final float fluidCoolantPerTick;
        private final float fluidFuelPerTick;
        private final int rfPerTick;

        private CombustionRecipeWrapper(FluidStack fluidCoolant, FluidStack fluidFuel, float fluidCoolantPerTick, float fluidFuelPerTick, int rfPerTick) {
            this.fluidCoolant = fluidCoolant;
            this.fluidFuel = fluidFuel;
            this.fluidCoolantPerTick = fluidCoolantPerTick;
            this.fluidFuelPerTick = fluidFuelPerTick;
            this.rfPerTick = rfPerTick;
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
        }

        @Nonnull
        public List<?> getInputs() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<FluidStack> getFluidInputs() {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>();
            result.add(this.fluidCoolant);
            result.add(this.fluidFuel);
            return result;
        }

        @Nonnull
        public List<?> getOutputs() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<FluidStack> getFluidOutputs() {
            return Collections.emptyList();
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            FontRenderer fr = minecraft.field_71466_p;
            String txt = EnderIO.lang.localize("combustionGenerator.output") + " " + PowerDisplayUtil.formatPower(this.rfPerTick) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
            int sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(88 - sw / 2 - xOff), (float)(fr.field_78288_b / 2), ColorUtil.getRGB((Color)Color.WHITE));
            int y = 21 - yOff - 2;
            int x = 114 - xOff;
            txt = this.fluidCoolantPerTick + " " + EnderIO.lang.localize("power.tmb");
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            x = 48 - xOff;
            txt = this.fluidFuelPerTick + " " + EnderIO.lang.localize("power.tmb");
            sw = fr.func_78256_a(txt);
            fr.func_175063_a(txt, (float)(x - sw / 2 + 7), (float)(y + fr.field_78288_b / 2 + 47), ColorUtil.getRGB((Color)Color.WHITE));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

