/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.integration.jei.BaseRecipeHandler;
import crazypants.enderio.integration.jei.ItemHelper;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class DarkSteelUpgradeRecipeCategory
extends BlankRecipeCategory<DarkSteelUpgradeRecipeWrapper> {
    @Nonnull
    public static final String UID = "DarkSteelUpgrade";
    private int xOff = 15;
    private int yOff = 40;
    @Nonnull
    private final IDrawable background;

    public static List<Triple<ItemStack, ItemStack, ItemStack>> getAllRecipes() {
        ArrayList<Triple<ItemStack, ItemStack, ItemStack>> list = new ArrayList<Triple<ItemStack, ItemStack, ItemStack>>();
        HashSet<String> seen = new HashSet<String>();
        List<ItemStack> items = DarkSteelRecipeManager.instance.getRecipes(seen, list, ItemHelper.getValidItems());
        while (!items.isEmpty()) {
            items = DarkSteelRecipeManager.instance.getRecipes(seen, list, items);
        }
        return list;
    }

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new DarkSteelUpgradeRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<DarkSteelUpgradeRecipeWrapper>(DarkSteelUpgradeRecipeWrapper.class, UID)});
        registry.addRecipeCategoryCraftingItem(new ItemStack(Blocks.field_150467_bQ), new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockDarkSteelAnvil), new String[]{UID});
        long start = System.nanoTime();
        List<Triple<ItemStack, ItemStack, ItemStack>> allRecipes = DarkSteelUpgradeRecipeCategory.getAllRecipes();
        long end = System.nanoTime();
        HashSet<Item> items = new HashSet<Item>();
        for (Triple<ItemStack, ItemStack, ItemStack> rec : allRecipes) {
            items.add(((ItemStack)rec.getLeft()).func_77973_b());
            items.add(((ItemStack)rec.getRight()).func_77973_b());
        }
        ISubtypeRegistry subtypeRegistry = registry.getJeiHelpers().getSubtypeRegistry();
        DarkSteelUpgradeSubtypeInterpreter dsusi = new DarkSteelUpgradeSubtypeInterpreter();
        for (Item item : items) {
            subtypeRegistry.registerNbtInterpreter(item, (ISubtypeRegistry.ISubtypeInterpreter)dsusi);
        }
        ArrayList<DarkSteelUpgradeRecipeWrapper> result = new ArrayList<DarkSteelUpgradeRecipeWrapper>();
        for (Triple<ItemStack, ItemStack, ItemStack> rec : allRecipes) {
            result.add(new DarkSteelUpgradeRecipeWrapper(rec));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerRepair.class, UID, 0, 2, 3, 36);
        Log.info(String.format("DarkSteelUpgradeRecipeCategory: Added %d dark steel upgrade recipes to JEI in %.3f seconds.", allRecipes.size(), (double)(end - start) / 1.0E9));
    }

    public DarkSteelUpgradeRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = new ResourceLocation("textures/gui/container/anvil.png");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 146, 24);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return Blocks.field_150467_bQ.func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull DarkSteelUpgradeRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 27 - this.xOff - 1, 47 - this.yOff - 1);
        guiItemStacks.init(1, true, 76 - this.xOff - 1, 47 - this.yOff - 1);
        guiItemStacks.init(2, false, 134 - this.xOff - 1, 47 - this.yOff - 1);
        guiItemStacks.setFromRecipe(0, recipeWrapper.stacks.getLeft());
        guiItemStacks.setFromRecipe(1, recipeWrapper.stacks.getMiddle());
        guiItemStacks.setFromRecipe(2, recipeWrapper.stacks.getRight());
    }

    public static class DarkSteelUpgradeSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        @Nullable
        public String getSubtypeInfo(@Nonnull ItemStack itemStack) {
            return DarkSteelRecipeManager.instance.getUpgradesAsString(itemStack);
        }
    }

    public static class DarkSteelUpgradeRecipeWrapper
    extends BlankRecipeWrapper {
        private final Triple<ItemStack, ItemStack, ItemStack> stacks;

        public DarkSteelUpgradeRecipeWrapper(Triple<ItemStack, ItemStack, ItemStack> stacks) {
            this.stacks = stacks;
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
        }

        @Nonnull
        public List<?> getInputs() {
            ArrayList<Object> itemInputs = new ArrayList<Object>();
            itemInputs.add(this.stacks.getLeft());
            itemInputs.add(this.stacks.getMiddle());
            return itemInputs;
        }

        @Nonnull
        public List<?> getOutputs() {
            return Collections.singletonList(this.stacks.getRight());
        }
    }
}

