/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.TooltipHandlerGrinding;
import crazypants.enderio.integration.jei.RecipeHandler;
import crazypants.enderio.integration.jei.RecipeWrapper;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeOutput;
import crazypants.enderio.machine.sagmill.ContainerSagMill;
import crazypants.enderio.machine.sagmill.GrindingBall;
import crazypants.enderio.machine.sagmill.GuiSagMill;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public class SagMillRecipeCategory
extends BlankRecipeCategory<SagRecipe>
implements ITooltipCallback<ItemStack> {
    @Nonnull
    public static final String UID = "SagMill";
    private int xOff = 45;
    private int yOff = 3;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arrow;
    private SagRecipe currentRecipe;
    private final TooltipHandlerGrinding ballsTT = new TooltipHandlerGrinding();

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SagMillRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new RecipeHandler<SagRecipe>(SagRecipe.class, UID)});
        registry.addRecipeClickArea(GuiSagMill.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockCrusher), new String[]{UID});
        ArrayList<SagRecipe> result = new ArrayList<SagRecipe>();
        for (IRecipe iRecipe : SagMillRecipeManager.getInstance().getRecipes()) {
            result.add(new SagRecipe(iRecipe));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerSagMill.class, UID, ContainerSagMill.FIRST_RECIPE_SLOT, ContainerSagMill.NUM_RECIPE_SLOT, ContainerSagMill.FIRST_INVENTORY_SLOT, ContainerSagMill.NUM_INVENTORY_SLOT);
    }

    public SagMillRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("crusher");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 109, 78);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 201, 1, 16, 22);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        String localizedName = EnderIO.blockCrusher.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 80 - this.xOff, 32 - this.yOff);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.currentRecipe == null) {
            return;
        }
        String energyString = PowerDisplayUtil.formatPower(this.currentRecipe.getEnergyRequired()) + " " + PowerDisplayUtil.abrevation();
        minecraft.field_71466_p.func_175065_a(energyString, (float)(135 - this.xOff), (float)(60 - this.yOff), 0x808080, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SagRecipe recipeWrapper) {
        this.currentRecipe = recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.addTooltipCallback((ITooltipCallback)this);
        guiItemStacks.init(0, true, 79 - this.xOff, 11 - this.yOff);
        guiItemStacks.init(1, false, 48 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(2, false, 69 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(3, false, 90 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(4, false, 111 - this.xOff, 58 - this.yOff);
        guiItemStacks.init(5, false, 121 - this.xOff, 22 - this.yOff);
        Object ingredients = this.currentRecipe.getInputs().get(0);
        if (ingredients != null) {
            guiItemStacks.setFromRecipe(0, ingredients);
        }
        int i = 1;
        for (Object output : this.currentRecipe.getOutputs()) {
            if (output == null) continue;
            guiItemStacks.setFromRecipe(i, output);
            ++i;
        }
        guiItemStacks.set(5, this.getBalls());
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (slotIndex == 0) {
            return;
        }
        if (slotIndex == 5) {
            if (this.ballsTT.shouldHandleItem(ingredient)) {
                this.ballsTT.addDetailedEntries(ingredient, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltip, true);
            }
            return;
        }
        if (slotIndex - 1 >= this.currentRecipe.getRecipe().getOutputs().length) {
            return;
        }
        RecipeOutput output = this.currentRecipe.getRecipe().getOutputs()[slotIndex - 1];
        float chance = output.getChance();
        if (chance > 0.0f && chance < 1.0f) {
            int chanceInt = (int)(chance * 100.0f);
            tooltip.add(TextFormatting.GRAY + MessageFormat.format(I18n.func_74838_a((String)"enderio.nei.sagmill.outputchance"), chanceInt));
        }
    }

    @Nonnull
    private List<ItemStack> getBalls() {
        List<GrindingBall> daBalls = SagMillRecipeManager.getInstance().getBalls();
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(null);
        for (GrindingBall ball : daBalls) {
            res.add(ball.getInput());
        }
        return res;
    }

    public static class SagRecipe
    extends RecipeWrapper {
        public SagRecipe(IRecipe recipe) {
            super(recipe);
        }
    }
}

