/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.jei;

import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.integration.jei.BaseRecipeHandler;
import crazypants.enderio.integration.jei.RecipeWrapper;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.vat.ContainerVat;
import crazypants.enderio.machine.vat.GuiVat;
import crazypants.enderio.machine.vat.VatRecipeManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.gui.ingredients.GuiIngredient;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class VatRecipeCategory
extends BlankRecipeCategory<VatRecipeWrapper> {
    @Nonnull
    public static final String UID = "Vat";
    private static final int xOff = 24;
    private static final int yOff = 9;
    @Nonnull
    private final IDrawable background;
    private VatRecipeWrapper currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new VatRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new BaseRecipeHandler<VatRecipeWrapper>(VatRecipeWrapper.class, UID){

            @Override
            public boolean isRecipeValid(@Nonnull VatRecipeWrapper recipe) {
                return recipe.isValid();
            }
        }});
        registry.addRecipeClickArea(GuiVat.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockVat), new String[]{UID});
        ArrayList<VatRecipeWrapper> result = new ArrayList<VatRecipeWrapper>();
        for (IRecipe rec : VatRecipeManager.getInstance().getRecipes()) {
            result.add(new VatRecipeWrapper(rec));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerVat.class, UID, ContainerVat.FIRST_RECIPE_SLOT, ContainerVat.NUM_RECIPE_SLOT, ContainerVat.FIRST_INVENTORY_SLOT, ContainerVat.NUM_INVENTORY_SLOT);
    }

    public VatRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("vat");
        this.background = guiHelper.createDrawable(backgroundLocation, 24, 9, 130, 70);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return EnderIO.blockVat.func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull VatRecipeWrapper recipeWrapper) {
        this.currentRecipe = recipeWrapper;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        Map ings = guiItemStacks.getGuiIngredients();
        this.currentRecipe.setInfoData(ings);
        guiItemStacks.init(0, true, 31, 2);
        guiItemStacks.init(1, true, 80, 2);
        ArrayList<ItemStack> inputsOne = new ArrayList<ItemStack>();
        ArrayList<ItemStack> inputsTwo = new ArrayList<ItemStack>();
        for (RecipeInput input : this.currentRecipe.getRecipe().getInputs()) {
            if (input.getInput() == null) continue;
            List<ItemStack> equivs = this.getInputStacks(input);
            if (input.getSlotNumber() == 0) {
                inputsOne.addAll(equivs);
                continue;
            }
            if (input.getSlotNumber() != 1) continue;
            inputsTwo.addAll(equivs);
        }
        guiItemStacks.set(0, inputsOne);
        guiItemStacks.set(1, inputsTwo);
    }

    private List<ItemStack> getInputStacks(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] eq = input.getEquivelentInputs();
        if (eq != null) {
            for (ItemStack st : eq) {
                result.add(st);
            }
        }
        return result;
    }

    public static class VatRecipeWrapper
    extends RecipeWrapper {
        private Rectangle inTankBounds = new Rectangle(6, 3, 15, 47);
        private Rectangle outTankBounds = new Rectangle(108, 3, 15, 47);
        Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients;
        private final FluidStack inputFl;
        private final FluidStack outputFl;

        public VatRecipeWrapper(IRecipe rec) {
            super(rec);
            FluidStack fl = null;
            for (RecipeInput ri : rec.getInputs()) {
                if (!ri.isFluid()) continue;
                fl = ri.getFluidInput();
                break;
            }
            this.inputFl = fl;
            this.outputFl = rec.getOutputs()[0].getFluidOutput();
        }

        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            if (this.currentIngredients == null || this.inputFl == null || this.outputFl == null) {
                return;
            }
            String str = this.getTextForSlot(0);
            if (str != null) {
                minecraft.field_71466_p.func_78276_b(str, 30, 22, 0x808080);
            }
            if ((str = this.getTextForSlot(1)) != null) {
                minecraft.field_71466_p.func_78276_b(str, 80, 22, 0x808080);
            }
            RenderUtil.renderGuiTank((FluidStack)this.inputFl, (int)this.inputFl.amount, (int)this.inputFl.amount, (double)this.inTankBounds.x, (double)this.inTankBounds.y, (double)0.0, (double)this.inTankBounds.width, (double)this.inTankBounds.height);
            RenderUtil.renderGuiTank((FluidStack)this.outputFl, (int)this.outputFl.amount, (int)this.outputFl.amount, (double)this.outTankBounds.x, (double)this.outTankBounds.y, (double)0.0, (double)this.outTankBounds.width, (double)this.outTankBounds.height);
            IRecipe rec = this.getRecipe();
            String energyString = PowerDisplayUtil.formatPower(rec.getEnergyRequired()) + " " + PowerDisplayUtil.abrevation();
            minecraft.field_71466_p.func_175065_a(energyString, 76.0f, 58.0f, 0x808080, false);
        }

        private String getTextForSlot(int forSlot) {
            ItemStack stack = null;
            IGuiIngredient<ItemStack> ging = this.currentIngredients.get(forSlot);
            if (ging instanceof GuiIngredient) {
                GuiIngredient gi = (GuiIngredient)ging;
                stack = (ItemStack)gi.getIngredient();
            }
            if (stack == null) {
                return null;
            }
            float mult = VatRecipeManager.getInstance().getMultiplierForInput(this.inputFl.getFluid(), stack, this.outputFl.getFluid());
            String str = "x" + mult;
            return str;
        }

        public void setInfoData(Map<Integer, ? extends IGuiIngredient<ItemStack>> ings) {
            this.currentIngredients = ings;
        }

        @Override
        @Nonnull
        public List<FluidStack> getFluidInputs() {
            return Collections.singletonList(this.inputFl);
        }

        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> res = new ArrayList<String>(2);
            if (this.inTankBounds.contains(mouseX, mouseY)) {
                res.add(this.inputFl.getLocalizedName());
            } else if (this.outTankBounds.contains(mouseX, mouseY)) {
                res.add(this.outputFl.getLocalizedName());
            }
            return res;
        }
    }
}

