/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.waila;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.block.BlockDarkSteelAnvil;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.integration.waila.IWailaInfoProvider;
import crazypants.enderio.integration.waila.IWailaNBTProvider;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.painter.blocks.BlockPaintedPressurePlate;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.IInternalPoweredTile;
import java.util.List;
import java.util.Locale;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.impl.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fluids.FluidStack;

public class WailaCompat
implements IWailaDataProvider {
    public static final WailaCompat INSTANCE = new WailaCompat();
    private static IWailaDataAccessor _accessor = null;

    public static void load(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockDarkSteelAnvil.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, BlockEio.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, BlockPaintedPressurePlate.class);
        registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, TileEntityEio.class);
        ConfigHandler.instance().addConfig("Ender IO", "facades.hidden", EnderIO.lang.localize("waila.config.hiddenfacades"));
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        BlockPos pos = accessor.getPosition();
        if (config.getConfig("facades.hidden")) {
            if (accessor.getBlock() instanceof IPaintable.IBlockPaintableBlock) {
                if (accessor.getTileEntity() instanceof IConduitBundle && ConduitUtil.isFacadeHidden((IConduitBundle)accessor.getTileEntity(), accessor.getPlayer())) {
                    return null;
                }
                IPaintable.IBlockPaintableBlock bundle = (IPaintable.IBlockPaintableBlock)accessor.getBlock();
                IBlockState facade = bundle.getPaintSource(accessor.getBlockState(), (IBlockAccess)accessor.getWorld(), pos);
                if (facade != null && facade.func_177230_c() != accessor.getBlock()) {
                    ItemStack ret = facade.func_177230_c().getPickBlock(facade, accessor.getMOP(), (World)new WailaWorldWrapper(accessor.getWorld()), pos, accessor.getPlayer());
                    return ret;
                }
            }
        } else if (accessor.getBlock() instanceof BlockDarkSteelAnvil) {
            return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IInternalPoweredTile power;
        _accessor = accessor;
        EntityPlayer player = accessor.getPlayer();
        BlockPos pos = accessor.getPosition();
        World world = accessor.getWorld();
        IBlockState bs = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        Item item = Item.func_150898_a((Block)block);
        ((ITaggedList)currenttip).removeEntries((Object)"RFEnergyStorage");
        if (te instanceof IIoConfigurable && block == accessor.getBlock()) {
            IIoConfigurable machine = (IIoConfigurable)te;
            EnumFacing side = accessor.getSide();
            IoMode mode = machine.getIoMode(side);
            currenttip.add(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.side", new Object[]{TextFormatting.WHITE + EnderIO.lang.localize("gui.machine.side." + side.name().toLowerCase(Locale.US))}));
            if (!(te instanceof TileInventoryPanel)) {
                currenttip.add(TextFormatting.YELLOW + EnderIO.lang.localize("gui.machine.ioMode", new Object[]{mode.colorLocalisedName()}));
            }
        }
        if (block instanceof IWailaInfoProvider) {
            IWailaInfoProvider info = (IWailaInfoProvider)block;
            if (block instanceof IAdvancedTooltipProvider) {
                int mask = info.getDefaultDisplayMask(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                boolean basic = (mask & 1) == 1;
                boolean common = (mask & 2) == 2;
                boolean detailed = (mask & 4) == 4;
                IAdvancedTooltipProvider adv = (IAdvancedTooltipProvider)block;
                if (common) {
                    adv.addCommonEntries(itemStack, player, currenttip, false);
                }
                if (SpecialTooltipHandler.showAdvancedTooltips() && detailed) {
                    adv.addDetailedEntries(itemStack, player, currenttip, false);
                } else if (detailed) {
                    SpecialTooltipHandler.addShowDetailsTooltip(currenttip);
                }
                if (!SpecialTooltipHandler.showAdvancedTooltips() && basic) {
                    adv.addBasicEntries(itemStack, player, currenttip, false);
                }
            } else if (block instanceof IResourceTooltipProvider) {
                SpecialTooltipHandler.INSTANCE.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
            }
            if (currenttip.size() > 0) {
                currenttip.add("");
            }
            info.getWailaInfo(currenttip, player, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (block instanceof IAdvancedTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IAdvancedTooltipProvider)block, itemStack, player, currenttip, false);
        } else if (item instanceof IAdvancedTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IAdvancedTooltipProvider)item, itemStack, player, currenttip, false);
        } else if (block instanceof IResourceTooltipProvider) {
            SpecialTooltipHandler.INSTANCE.addInformation((IResourceTooltipProvider)block, itemStack, player, currenttip);
        }
        if (te instanceof IConduitBundle) {
            this.getWailaBodyConduitBundle(itemStack, currenttip);
        } else if (te instanceof IInternalPoweredTile && block == accessor.getBlock() && !(te instanceof TileCapBank) && (power = (IInternalPoweredTile)te).displayPower()) {
            if (currenttip.size() > 4) {
                currenttip.add("");
            }
            int stored = accessor.getNBTData().func_74762_e("storedEnergyRF");
            int max = accessor.getNBTData().func_74762_e("maxStoredRF");
            currenttip.add(String.format("%s%s%s / %s%s%s %s", TextFormatting.WHITE, PowerDisplayUtil.formatPower(stored), TextFormatting.RESET, TextFormatting.WHITE, PowerDisplayUtil.formatPower(max), TextFormatting.RESET, PowerDisplayUtil.abrevation()));
        }
        return currenttip;
    }

    private void getWailaBodyConduitBundle(ItemStack itemStack, List<String> currenttip) {
        NBTTagCompound nbtRoot;
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() == EnderIO.itemPowerConduit) {
            NBTTagCompound nbtRoot2 = _accessor.getNBTData();
            if (nbtRoot2.func_74764_b("storedEnergyRF")) {
                int stored = nbtRoot2.func_74762_e("storedEnergyRF");
                int max = nbtRoot2.func_74762_e("maxStoredRF");
                currenttip.add(String.format("%s%s%s / %s%s%s %s", TextFormatting.WHITE, PowerDisplayUtil.formatPower(stored), TextFormatting.RESET, TextFormatting.WHITE, PowerDisplayUtil.formatPower(max), TextFormatting.RESET, PowerDisplayUtil.abrevation()));
            }
            if (nbtRoot2.func_74764_b("maxStoredRF")) {
                int max = nbtRoot2.func_74762_e("maxStoredRF");
                currenttip.add(String.format("%s %s %s", "Max", PowerDisplayUtil.formatPower(max), PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr()));
            }
        } else if (itemStack.func_77973_b() == EnderIO.itemLiquidConduit && (nbtRoot = _accessor.getNBTData()).func_74764_b("fluidLocked") && nbtRoot.func_74764_b("FluidName")) {
            boolean fluidTypeLocked = nbtRoot.func_74767_n("fluidLocked");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot);
            String lockedStr = fluidTypeLocked ? EnderIO.lang.localize("itemLiquidConduit.lockedWaila") : "";
            String fluidName = fluid.getLocalizedName();
            int fluidAmount = fluid.amount;
            if (fluidAmount > 0) {
                currenttip.add(String.format("%s%s%s%s %s%s%s %s", lockedStr, TextFormatting.WHITE, fluidName, TextFormatting.RESET, TextFormatting.WHITE, PowerDisplayUtil.formatPower(fluidAmount), TextFormatting.RESET, Fluids.MB()));
            } else if (fluidTypeLocked) {
                currenttip.add(String.format("%s%s%s%s", lockedStr, TextFormatting.WHITE, fluidName, TextFormatting.RESET));
            }
        }
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof IWailaNBTProvider) {
            ((IWailaNBTProvider)te).getData(tag);
        }
        if (te instanceof IConduitBundle) {
            FluidStack fluid;
            AbstractTankConduit atc;
            IConduitBundle icb = (IConduitBundle)te;
            IPowerConduit pc = icb.getConduit(IPowerConduit.class);
            if (pc != null) {
                tag.func_74768_a("maxStoredRF", pc.getMaxEnergyStored(null));
                if (icb.displayPower()) {
                    tag.func_74768_a("storedEnergyRF", pc.getEnergyStored(null));
                }
            }
            if ((atc = icb.getConduit(AbstractTankConduit.class)) != null && (fluid = atc.getTank().getFluid()) != null) {
                tag.func_74757_a("fluidLocked", atc.isFluidTypeLocked());
                fluid.writeToNBT(tag);
            }
        } else if (te instanceof IInternalPoweredTile) {
            IInternalPoweredTile ipte = (IInternalPoweredTile)te;
            tag.func_74768_a("storedEnergyRF", ipte.getEnergyStored(null));
            tag.func_74768_a("maxStoredRF", ipte.getMaxEnergyStored(null));
        }
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    public static NBTTagCompound getNBTData() {
        return _accessor.getNBTData();
    }

    private class WailaWorldWrapper
    extends World {
        private final World wrapped;

        private WailaWorldWrapper(World wrapped) {
            super(wrapped.func_72860_G(), wrapped.func_72912_H(), wrapped.field_73011_w, wrapped.field_72984_F, wrapped.field_72995_K);
            this.wrapped = wrapped;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            IBlockState bs = this.wrapped.func_180495_p(pos);
            Block block = bs.func_177230_c();
            if (block instanceof IPaintable.IBlockPaintableBlock) {
                return ((IPaintable.IBlockPaintableBlock)block).getPaintSource(bs, (IBlockAccess)this.wrapped, pos);
            }
            return bs;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            IBlockState bs = this.func_180495_p(pos);
            Block block = bs.func_177230_c();
            if (block == null || !block.hasTileEntity(bs)) {
                return null;
            }
            TileEntity te = block.createTileEntity((World)this, bs);
            if (te == null) {
                return null;
            }
            te.func_145834_a((World)this);
            te.func_174878_a(pos);
            return te;
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public Entity func_73045_a(int p_73045_1_) {
            return null;
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return true;
        }
    }
}

