/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.buffer.BlockItemBuffer;
import crazypants.enderio.machine.buffer.BufferType;
import crazypants.enderio.machine.buffer.ContainerBuffer;
import crazypants.enderio.machine.buffer.GuiBuffer;
import crazypants.enderio.machine.buffer.PacketBufferIO;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumRenderMode;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBuffer
extends AbstractMachineBlock<TileBuffer>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockBuffer create() {
        PacketHandler.INSTANCE.registerMessage(PacketBufferIO.class, PacketBufferIO.class, PacketHandler.nextID(), Side.SERVER);
        BlockBuffer res = new BlockBuffer();
        res.init();
        return res;
    }

    private BlockBuffer() {
        super(ModObject.blockBuffer, TileBuffer.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(BufferType.TYPE, (Comparable)((Object)BufferType.ITEM)));
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemBuffer((Block)this, this.name);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, BufferType.TYPE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BufferType.TYPE, (Comparable)((Object)BufferType.getTypeFromMeta(meta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return BufferType.getMetaFromType((BufferType)((Object)state.func_177229_b(BufferType.TYPE)));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    public int func_180651_a(IBlockState st) {
        return this.func_176201_c(st);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (BufferType type : BufferType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileBuffer) {
            return new ContainerBuffer(player.field_71071_by, (TileBuffer)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileBuffer) {
            return new GuiBuffer(player.field_71071_by, (TileBuffer)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 100;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileBuffer tileEntity) {
        blockStateWrapper.addCacheKey(blockStateWrapper.func_177229_b((IProperty)BufferType.TYPE));
    }
}

