/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Lists;
import crazypants.enderio.machine.farm.FarmStationContainer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public enum Fertilizer {
    NONE((ItemStack)null){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            return false;
        }
    }
    ,
    BONEMEAL(new ItemStack(Items.field_151100_aR, 1, 15)){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            EnumActionResult res = stack.func_77973_b().func_180614_a(stack, player, world, bc.getBlockPos(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
            return res != null && res != EnumActionResult.PASS;
        }
    }
    ,
    FORESTRY_FERTILIZER_COMPOUND((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Forestry", "fertilizerCompound"))){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            return BONEMEAL.apply(stack, player, world, bc);
        }
    }
    ,
    BOTANIA_FLORAL_FERTILIZER((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Botania", "fertilizer"))){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            BlockCoord below = bc.getLocation(EnumFacing.DOWN);
            Block belowBlock = below.getBlock((IBlockAccess)world);
            if (belowBlock == Blocks.field_150346_d || belowBlock == Blocks.field_150349_c) {
                EnumActionResult res = stack.func_77973_b().func_180614_a(stack, player, world, below.getBlockPos(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
                return res != null && res != EnumActionResult.PASS;
            }
            return false;
        }

        @Override
        public boolean applyOnAir() {
            return true;
        }

        @Override
        public boolean applyOnPlant() {
            return false;
        }
    }
    ,
    METALLURGY_FERTILIZER((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Metallurgy", "fertilizer"))){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            return BONEMEAL.apply(stack, player, world, bc);
        }
    }
    ,
    GARDEN_CORE_COMPOST((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("GardenCore", "compost_pile"))){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            return BONEMEAL.apply(stack, player, world, bc);
        }
    }
    ,
    MAGICALCROPS_FERTILIZER((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("magicalcrops", "magicalcrops_MagicalCropFertilizer"))){

        @Override
        public boolean apply(ItemStack stack, EntityPlayer player, World world, BlockCoord bc) {
            return BONEMEAL.apply(stack, player, world, bc);
        }
    };

    private ItemStack stack;
    private static final List<Fertilizer> validFertilizers;

    private Fertilizer(Item item) {
        this(new ItemStack(item));
    }

    private Fertilizer(Block block) {
        this(new ItemStack(block));
    }

    private Fertilizer(ItemStack stack) {
        ItemStack itemStack = this.stack = stack == null || stack.func_77973_b() == null ? null : stack;
        if (this.stack != null) {
            FarmStationContainer.slotItemsFertilizer.add(this.stack);
        }
    }

    public static Fertilizer getInstance(ItemStack stack) {
        for (Fertilizer fertilizer : validFertilizers) {
            if (!fertilizer.matches(stack)) continue;
            return fertilizer;
        }
        return NONE;
    }

    public static boolean isFertilizer(ItemStack stack) {
        return Fertilizer.getInstance(stack) != NONE;
    }

    protected boolean matches(ItemStack stack) {
        return OreDictionary.itemMatches((ItemStack)this.stack, (ItemStack)stack, (boolean)false);
    }

    public abstract boolean apply(ItemStack var1, EntityPlayer var2, World var3, BlockCoord var4);

    public boolean applyOnAir() {
        return false;
    }

    public boolean applyOnPlant() {
        return true;
    }

    static {
        validFertilizers = Lists.newArrayList();
        for (Fertilizer f : Fertilizer.values()) {
            if (f.stack == null) continue;
            validFertilizers.add(f);
        }
    }
}

