/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.Things;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class OredictTreeFarmer
extends TreeFarmer {
    protected Things saplings;
    protected Things woodBlocks;

    public OredictTreeFarmer(Things saplings, Things woods) {
        super(null, new Block[0]);
        this.saplings = saplings;
        this.woodBlocks = woods;
        FarmStationContainer.slotItemsSeeds.addAll(saplings.getItemStacks());
        FarmStationContainer.slotItemsProduce.addAll(woods.getItemStacks());
    }

    @Override
    protected boolean isWood(Block block) {
        return this.woodBlocks.contains(block);
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return stack != null && this.saplings.contains(stack) && Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (this.saplings.contains(block)) {
            return true;
        }
        return this.plantFromInventory(farm, bc, block, meta);
    }

    @Override
    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        ItemStack seed;
        ItemStack sapling;
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc, sapling = farm.getSeedTypeInSuppliesFor(bc)) && (seed = farm.takeSeedFromSupplies(sapling, bc, false)) != null) {
            return this.plant(farm, worldObj, bc, seed);
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc, ItemStack sapling) {
        if (!this.saplings.contains(sapling)) {
            return false;
        }
        BlockPos grnPos = bc.getBlockPos().func_177977_b();
        IBlockState bs = worldObj.func_180495_p(grnPos);
        Block ground = bs.func_177230_c();
        Block saplingBlock = Block.func_149634_a((Item)sapling.func_77973_b());
        if (saplingBlock == null) {
            return false;
        }
        if (saplingBlock.func_176196_c(worldObj, bc.getBlockPos())) {
            if (saplingBlock instanceof IPlantable) {
                return ground.canSustainPlant(bs, (IBlockAccess)worldObj, grnPos, EnumFacing.UP, (IPlantable)saplingBlock);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc, ItemStack seed) {
        worldObj.func_175698_g(bc.getBlockPos());
        Item item = seed.func_77973_b();
        worldObj.func_180501_a(bc.getBlockPos(), Block.func_149634_a((Item)item).func_176203_a(item.func_77647_b(seed.func_77960_j())), 3);
        farm.actionPerformed(false);
        return true;
    }
}

