/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.IFluidCoolant;
import crazypants.enderio.fluid.IFluidFuel;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileCombustionGenerator
extends AbstractGeneratorEntity
implements ITankAccess.IExtendedTankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    private final SmartTank coolantTank = new SmartTank(5000){

        @Override
        public boolean canFillFluidType(FluidStack resource) {
            return super.canFillFluidType(resource) && FluidFuelRegister.instance.getCoolant(resource.getFluid()) != null;
        }
    };
    @Store
    private final SmartTank fuelTank = new SmartTank(5000){

        @Override
        public boolean canFillFluidType(FluidStack resource) {
            return super.canFillFluidType(resource) && FluidFuelRegister.instance.getFuel(resource.getFluid()) != null;
        }
    };
    private boolean tanksDirty;
    @Store(value={Store.StoreFor.ITEM, Store.StoreFor.SAVE})
    private int ticksRemaingFuel;
    @Store(value={Store.StoreFor.ITEM, Store.StoreFor.SAVE})
    private int ticksRemaingCoolant;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean active;
    private PowerDistributor powerDis;
    @Store(value={Store.StoreFor.CLIENT})
    private int generated;
    private boolean inPause = false;
    private boolean generatedDirty = false;
    private int maxOutputTick = 1280;
    private static int IO_MB_TICK = 250;
    private IFluidFuel curFuel;
    private IFluidCoolant curCoolant;
    public static float HEAT_PER_RF = 2.3E-4f;
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileCombustionGenerator() {
        super(new SlotDefinition(-1, -1, -1, -1, -1, -1), ModObject.blockCombustionGenerator);
        this.coolantTank.setTileEntity((TileEntity)this);
        this.coolantTank.setCanDrain(false);
        this.fuelTank.setTileEntity((TileEntity)this);
        this.fuelTank.setCanDrain(false);
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        if (dir != null && this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.fuelTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        if (dir != null && this.coolantTank.getFluidAmount() < this.coolantTank.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.coolantTank, (int)IO_MB_TICK) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockCombustionGenerator.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        boolean res = false;
        if (!redstoneChecksPassed) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        int lastGenerated = this.generated;
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (lastGenerated != this.generated) {
            this.generatedDirty = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketCombustionTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        if (this.generatedDirty && this.shouldDoWorkThisTick(10)) {
            this.generatedDirty = false;
            res = true;
        }
        return res;
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.maxOutputTick, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    private boolean generateEnergy() {
        int drained;
        this.generated = 0;
        if (this.ticksRemaingCoolant <= 0 && this.getCoolantTank().getFluidAmount() <= 0 || this.ticksRemaingFuel <= 0 && this.getFuelTank().getFluidAmount() <= 0 || this.getEnergyStored() >= this.getMaxEnergyStored()) {
            return false;
        }
        if (this.inPause) {
            int powerPerCycle = this.getPowerPerCycle();
            if (this.getEnergyStored() >= this.getMaxEnergyStored() - powerPerCycle * 200 && this.getEnergyStored() > this.getMaxEnergyStored() / 8) {
                return false;
            }
        }
        this.inPause = false;
        --this.ticksRemaingFuel;
        if (this.ticksRemaingFuel <= 0) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            if (this.curFuel == null) {
                return false;
            }
            drained = this.getFuelTank().removeFluidAmount(100);
            if (drained == 0) {
                return false;
            }
            this.ticksRemaingFuel = TileCombustionGenerator.getNumTicksPerMbFuel(this.curFuel) * drained;
        } else if (this.curFuel == null) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            if (this.curFuel == null) {
                return false;
            }
        }
        --this.ticksRemaingCoolant;
        if (this.ticksRemaingCoolant <= 0) {
            this.updateCoolantFromTank();
            if (this.curCoolant == null) {
                return false;
            }
            drained = this.getCoolantTank().removeFluidAmount(100);
            if (drained == 0) {
                return false;
            }
            this.ticksRemaingCoolant = TileCombustionGenerator.getNumTicksPerMbCoolant(this.curCoolant, this.curFuel) * drained;
        } else if (this.curCoolant == null) {
            this.updateCoolantFromTank();
            if (this.curCoolant == null) {
                return false;
            }
        }
        this.generated = this.getPowerPerCycle();
        this.setEnergyStored(this.getEnergyStored() + this.generated);
        return this.getFuelTank().getFluidAmount() > 0 && this.getCoolantTank().getFluidAmount() > 0;
    }

    protected void updateCoolantFromTank() {
        this.curCoolant = FluidFuelRegister.instance.getCoolant(this.getCoolantTank().getFluid());
    }

    private int getPowerPerCycle() {
        return this.curFuel == null ? 0 : this.curFuel.getPowerPerCycle();
    }

    public int getNumTicksPerMbFuel() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        return TileCombustionGenerator.getNumTicksPerMbFuel(FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid().getFluid()));
    }

    public int getNumTicksPerMbCoolant() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        if (this.field_145850_b.field_72995_K) {
            this.curFuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
            this.updateCoolantFromTank();
        }
        return TileCombustionGenerator.getNumTicksPerMbCoolant(this.curCoolant, this.curFuel);
    }

    public static int getNumTicksPerMbFuel(IFluidFuel fuel) {
        if (fuel == null) {
            return 0;
        }
        return fuel.getTotalBurningTime() / 1000;
    }

    public static int getNumTicksPerMbCoolant(IFluidCoolant coolant, IFluidFuel fuel) {
        if (coolant == null || fuel == null) {
            return 0;
        }
        float power = fuel.getPowerPerCycle();
        float cooling = coolant.getDegreesCoolingPerMB(100.0f);
        double toCool = 1.0 / (double)(HEAT_PER_RF * power);
        int numTicks = (int)Math.round(toCool / (double)(cooling * 1000.0f));
        return numTicks;
    }

    public int getGeneratedLastTick() {
        if (!this.active) {
            return 0;
        }
        return this.generated;
    }

    @Override
    public int getPowerUsePerTick() {
        if (this.getFuelTank().getFluidAmount() <= 0) {
            return 0;
        }
        IFluidFuel fuel = FluidFuelRegister.instance.getFuel(this.getFuelTank().getFluid());
        if (fuel == null) {
            return 0;
        }
        return fuel.getPowerPerCycle();
    }

    public SmartTank getCoolantTank() {
        return this.coolantTank;
    }

    public SmartTank getFuelTank() {
        return this.fuelTank;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null) {
            if (FluidFuelRegister.instance.getCoolant(forFluidType.getFluid()) != null) {
                return this.coolantTank;
            }
            if (FluidFuelRegister.instance.getFuel(forFluidType.getFluid()) != null) {
                return this.fuelTank;
            }
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        ArrayList<ITankAccess.ITankData> result = new ArrayList<ITankAccess.ITankData>();
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileCombustionGenerator.this.fuelTank.getFluid();
            }

            public int getCapacity() {
                return TileCombustionGenerator.this.fuelTank.getCapacity();
            }
        });
        result.add(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.INPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileCombustionGenerator.this.coolantTank.getFluid();
            }

            public int getCapacity() {
                return TileCombustionGenerator.this.coolantTank.getCapacity();
            }
        });
        return result;
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.coolantTank, this.fuelTank});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getSmartTankFluidHandler().has(facingIn);
        }
        return super.hasCapability(capability, facingIn);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

