/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGuiSettingsUpdated
extends MessageTileEntity<TileInventoryPanel>
implements IMessageHandler<PacketGuiSettingsUpdated, IMessage> {
    private int sortMode;
    private String filterString;
    private boolean sync;

    public PacketGuiSettingsUpdated() {
    }

    public PacketGuiSettingsUpdated(TileInventoryPanel tile) {
        super((TileEntity)tile);
        this.sortMode = tile.getGuiSortMode();
        this.filterString = tile.getGuiFilterString();
        this.sync = tile.getGuiSync();
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.sortMode = buf.readInt();
        this.filterString = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.sync = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.sortMode);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filterString);
        buf.writeBoolean(this.sync);
    }

    public IMessage onMessage(PacketGuiSettingsUpdated message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.field_70170_p.func_175625_s(message.getPos());
        if (te instanceof TileInventoryPanel) {
            TileInventoryPanel teInvPanel = (TileInventoryPanel)te;
            teInvPanel.setGuiParameter(message.sortMode, message.filterString, message.sync);
        }
        return null;
    }
}

