/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.remote;

import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public enum ItemRemoteInvAccessType {
    BASIC(0, "basic", 80, false, true),
    ADVANCED(1, "advanced", -1, false, true),
    ENDER(2, "ender", -1, true, true);

    private final String nameSuffix;
    private final int range;
    private final boolean interdimensional;
    private final boolean visible;

    private ItemRemoteInvAccessType(int index, String nameSuffix, int range, boolean interdimensional, boolean visible) {
        this.nameSuffix = nameSuffix;
        this.range = range;
        this.interdimensional = interdimensional;
        this.visible = visible;
    }

    public int toMetadata() {
        return this.ordinal();
    }

    public static ItemRemoteInvAccessType fromMetadata(int meta) {
        return ItemRemoteInvAccessType.values()[meta >= 0 && meta < ItemRemoteInvAccessType.values().length ? meta : 0];
    }

    public static ItemRemoteInvAccessType fromStack(ItemStack stack) {
        return ItemRemoteInvAccessType.fromMetadata(stack != null ? stack.func_77960_j() : 0);
    }

    public boolean inRange(int dim0, int x0, int y0, int z0, int dim1, int x1, int y1, int z1) {
        if (!this.interdimensional && dim0 != dim1) {
            return false;
        }
        if (this.range < 0) {
            return true;
        }
        return Math.abs(x0 - x1) <= this.range && Math.abs(y0 - y1) <= this.range && Math.abs(z0 - z1) <= this.range;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String getUnlocalizedName(String basename) {
        return basename + this.getNameSuffix();
    }

    public int getRange() {
        return this.range;
    }

    public boolean isInterdimensional() {
        return this.interdimensional;
    }

    public int getRfCapacity() {
        return Config.remoteInventoryRFCapacity[this.ordinal()];
    }

    public int getFluidCapacity() {
        return Config.remoteInventoryMBCapacity[this.ordinal()];
    }

    public Fluid getFluidType() {
        Fluid fluid = null;
        fluid = FluidRegistry.getFluid((String)Config.remoteInventoryFluidTypes[this.ordinal()]);
        if (fluid == null) {
            Log.warn("ItemRemoteInvAccessType: Could not find fluid '" + Config.remoteInventoryFluidTypes[this.ordinal()] + "' using default fluid " + Fluids.fluidNutrientDistillation);
            fluid = Fluids.fluidNutrientDistillation;
        }
        return fluid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMbPerOpen() {
        return Config.remoteInventoryMBPerOpen[this.ordinal()];
    }

    public int getRfPerTick() {
        return Config.remoteInventoryRFPerTick[this.ordinal()];
    }
}

