/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DynaTextureProvider {
    protected static final int TEXSIZE = 32;
    @Nonnull
    protected static final Queue<ResourceLocation> toFree = new ConcurrentLinkedQueue<ResourceLocation>();
    @Nonnull
    protected static final List<DynaTextureProvider> instances = new ArrayList<DynaTextureProvider>();
    @Nonnull
    protected static final ResourceLocation pmon_screen = new ResourceLocation(EnderIO.DOMAIN, "textures/blocks/blockPMonScreen.png");
    @Nonnull
    protected static final int[] pmon_screen_data = new int[1024];
    @Nonnull
    protected static final ResourceLocation pmon_color = new ResourceLocation(EnderIO.DOMAIN, "textures/blocks/blockPMonColor.png");
    @Nonnull
    protected static final int[] pmon_color_data = new int[1024];
    protected static final ResourceLocation pmon_fallback = new ResourceLocation(EnderIO.DOMAIN, "textures/blocks/blockPMon.png");
    @Nonnull
    protected final TilePowerMonitor owner;
    @Nonnull
    protected final String id;
    @Nullable
    protected ResourceLocation resourceLocation;
    @Nonnull
    protected final int[] imageData;
    @Nonnull
    protected final DynamicTexture dynamicTexture;
    @Nonnull
    protected final TextureManager textureManager;
    @Nonnull
    protected final IResourceManager resourceManager;
    protected static boolean texturesLoaded = false;

    public DynaTextureProvider(@Nonnull TilePowerMonitor owner) {
        this.owner = owner;
        this.textureManager = Minecraft.func_71410_x().func_110434_K();
        this.resourceManager = Minecraft.func_71410_x().func_110442_L();
        this.id = EnderIO.DOMAIN + "pmon/" + owner.func_174877_v().func_177986_g();
        this.dynamicTexture = new DynamicTexture(32, 32);
        this.imageData = this.dynamicTexture.func_110565_c();
        this.resourceLocation = this.textureManager.func_110578_a(this.id, this.dynamicTexture);
        for (int i = 0; i < this.imageData.length; ++i) {
            this.imageData[i] = 0;
        }
        this.loadTextures();
        this.updateTexture();
        instances.add(this);
    }

    protected void loadTextures() {
        if (!texturesLoaded) {
            BufferedImage pmon_color_image;
            BufferedImage pmon_screen_image = this.getTexture(pmon_screen);
            if (pmon_screen_image != null) {
                pmon_screen_image = DynaTextureProvider.resize(pmon_screen_image, 32);
                pmon_screen_image.getRGB(0, 0, 32, 32, pmon_screen_data, 0, 32);
            }
            if ((pmon_color_image = this.getTexture(pmon_color)) != null) {
                pmon_color_image = DynaTextureProvider.resize(pmon_color_image, 32);
                pmon_color_image.getRGB(0, 0, 32, 32, pmon_color_data, 0, 32);
            }
            texturesLoaded = true;
            MinecraftForge.EVENT_BUS.register((Object)new Unloader());
        }
    }

    protected static BufferedImage resize(BufferedImage image, int size) {
        if (image.getWidth() != size) {
            BufferedImage resized = new BufferedImage(size, size, 2);
            Graphics2D g = resized.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(image, 0, 0, size, size, 0, 0, image.getWidth(), image.getHeight(), null);
            g.dispose();
            return resized;
        }
        return image;
    }

    protected BufferedImage getTexture(@Nonnull ResourceLocation blockResource) {
        try {
            IResource iResource = this.resourceManager.func_110536_a(blockResource);
            BufferedImage image = ImageIO.read(iResource.func_110527_b());
            iResource.close();
            return image;
        }
        catch (IOException e) {
            Log.error("Failed to load " + blockResource + ": " + e);
            return null;
        }
    }

    public void updateTexture() {
        if (this.resourceLocation != null) {
            int[][] minmax = this.owner.getIconValues();
            for (int x = 0; x < 32; ++x) {
                for (int y = 0; y < 32; ++y) {
                    this.imageData[y * 32 + x] = (x > 27 || 32 - y > minmax[1][x] * 23 / 63 + 5 || 32 - y < minmax[0][x] * 23 / 63 + 5 ? pmon_screen_data : pmon_color_data)[y * 32 + x];
                }
            }
            this.dynamicTexture.func_110564_a();
        }
    }

    public void bindTexture() {
        if (this.resourceLocation != null) {
            this.textureManager.func_110577_a(this.resourceLocation);
        } else {
            this.textureManager.func_110577_a(pmon_fallback);
        }
    }

    public void free() {
        if (this.resourceLocation != null) {
            this.textureManager.func_147645_c(this.resourceLocation);
            this.resourceLocation = null;
        }
        ResourceLocation r = toFree.poll();
        while (r != null) {
            this.textureManager.func_147645_c(r);
            r = toFree.poll();
        }
    }

    protected void finalize() throws Throwable {
        if (this.resourceLocation != null) {
            toFree.add(this.resourceLocation);
            this.resourceLocation = null;
        }
        super.finalize();
    }

    public static class Unloader {
        @SubscribeEvent
        public void unload(WorldEvent.Unload event) {
            if (event.getWorld() instanceof WorldClient) {
                for (DynaTextureProvider instance : instances) {
                    instance.free();
                }
                instances.clear();
            }
        }
    }
}

