/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.integration.waila.IWailaInfoProvider;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.EnumPressurePlateType;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.PressurePlatePainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.property.IOMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.render.util.QuadCollector;
import crazypants.util.CapturedMob;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedPressurePlate
extends BlockBasePressurePlate
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
BlockItemPaintedBlock.INamedSubBlocks,
IResourceTooltipProvider,
IWailaInfoProvider,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    private final String name;
    private final IBlockState[] defaultPaints = new IBlockState[EnumPressurePlateType.values().length];

    public static BlockPaintedPressurePlate create() {
        BlockPaintedPressurePlate result = new BlockPaintedPressurePlate(ModObject.blockPaintedPressurePlate.getUnlocalisedName());
        result.func_149711_c(0.5f);
        result.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new PressurePlatePainterTemplate(result, EnumPressurePlateType.WOOD.getMetaFromType(), Blocks.field_150452_aw));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new PressurePlatePainterTemplate(result, EnumPressurePlateType.STONE.getMetaFromType(), Blocks.field_150456_au));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new PressurePlatePainterTemplate(result, EnumPressurePlateType.IRON.getMetaFromType(), Blocks.field_150443_bT));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new PressurePlatePainterTemplate(result, EnumPressurePlateType.GOLD.getMetaFromType(), Blocks.field_150445_bS));
        return result;
    }

    public BlockPaintedPressurePlate(String name) {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(EnderIOTab.tabEnderIO);
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(SoundType.field_185848_a);
    }

    private void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedPressurePlate(this, this.name));
        GameRegistry.registerTileEntity(TilePaintedPressurePlate.class, (String)(this.name + "TileEntity"));
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("pressure_plate_up", new ResourceLocation("minecraft", "block/stone_pressure_plate_up"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("pressure_plate_down", new ResourceLocation("minecraft", "block/stone_pressure_plate_down"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("pressure_plate_inventory", new ResourceLocation("minecraft", "block/stone_pressure_plate_up"), PaintRegistry.PaintMode.ALL_TEXTURES);
        this.defaultPaints[EnumPressurePlateType.WOOD.ordinal()] = Blocks.field_150452_aw.func_176223_P();
        this.defaultPaints[EnumPressurePlateType.STONE.ordinal()] = Blocks.field_150456_au.func_176223_P();
        this.defaultPaints[EnumPressurePlateType.IRON.ordinal()] = Blocks.field_150443_bT.func_176223_P();
        this.defaultPaints[EnumPressurePlateType.GOLD.ordinal()] = Blocks.field_150445_bS.func_176223_P();
        this.defaultPaints[EnumPressurePlateType.DARKSTEEL.ordinal()] = this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(1));
        this.defaultPaints[EnumPressurePlateType.SOULARIUM.ordinal()] = this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(2));
        this.defaultPaints[EnumPressurePlateType.TUNED.ordinal()] = this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(3));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TilePaintedPressurePlate();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockPressurePlateWeighted.field_176579_a});
    }

    protected int func_180669_e(World worldIn, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            EnumPressurePlateType type = ((TilePaintedPressurePlate)te).getType();
            return type.getCountingMode().count(worldIn.func_175647_a(type.getSearchClass(), field_185511_c.func_186670_a(pos), type.getPredicate(this.getMobType((IBlockAccess)worldIn, pos))));
        }
        return this.func_176576_e(worldIn.func_180495_p(pos));
    }

    protected int func_176576_e(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    protected IBlockState func_176575_a(IBlockState state, int strength) {
        return state.func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(strength));
    }

    protected void setTypeFromMeta(IBlockAccess worldIn, BlockPos pos, int meta) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setType(EnumPressurePlateType.getTypeFromMeta(meta));
            ((TilePaintedPressurePlate)te).setSilent(EnumPressurePlateType.getSilentFromMeta(meta));
        }
    }

    protected int getMetaForStack(IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.getMetaFromType(((TilePaintedPressurePlate)te).getType(), ((TilePaintedPressurePlate)te).isSilent());
        }
        return 0;
    }

    protected EnumPressurePlateType getType(IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getType();
        }
        return EnumPressurePlateType.WOOD;
    }

    protected boolean isSilent(IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).isSilent();
        }
        return false;
    }

    protected CapturedMob getMobType(IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getMobType();
        }
        return null;
    }

    protected void setMobType(IBlockAccess worldIn, BlockPos pos, CapturedMob mobType) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setMobType(mobType);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.setTypeFromMeta((IBlockAccess)worldIn, pos, stack.func_77960_j());
        this.setPaintSource(state, (IBlockAccess)worldIn, pos, PainterUtil2.getSourceBlock(stack));
        this.setRotation((IBlockAccess)worldIn, pos, EnumFacing.func_176733_a((double)placer.field_70177_z));
        this.setMobType((IBlockAccess)worldIn, pos, CapturedMob.create(stack));
        if (!worldIn.field_72995_K) {
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        this.setRotation((IBlockAccess)world, pos, this.getRotation((IBlockAccess)world, pos).func_176732_a(EnumFacing.Axis.Y));
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack item) {
        super.func_180657_a(worldIn, player, pos, state, te, item);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.singletonList(this.getDrop(world, pos));
    }

    protected ItemStack getDrop(IBlockAccess world, BlockPos pos) {
        CapturedMob mobType = this.getMobType(world, pos);
        ItemStack drop = mobType != null ? mobType.toStack(Item.func_150898_a((Block)this), this.getMetaForStack(world, pos), 1) : new ItemStack(Item.func_150898_a((Block)this), 1, this.getMetaForStack(world, pos));
        PainterUtil2.setSourceBlock(drop, this.getPaintSource(null, world, pos));
        return drop;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDrop((IBlockAccess)world, pos);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            if (this.defaultPaints[this.getType(world, pos).ordinal()] == paintSource) {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(null);
            } else {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
            }
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        if (this.defaultPaints[EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal()] == paintSource) {
            PainterUtil2.setSourceBlock(stack, null);
        } else {
            PainterUtil2.setSourceBlock(stack, paintSource);
        }
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState paintSource;
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity && (paintSource = ((IPaintable.IPaintableTileEntity)te).getPaintSource()) != null) {
            return paintSource;
        }
        return this.defaultPaints[this.getType(world, pos).ordinal()];
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        IBlockState paintSource = PainterUtil2.getSourceBlock(stack);
        return paintSource != null ? paintSource : this.defaultPaints[EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal()];
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
            blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(this.getRotation(world, pos)).addCacheKey((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint, EnumFacing facing) {
        ModelRotation rot;
        switch (facing) {
            case EAST: {
                rot = ModelRotation.X0_Y90;
                break;
            }
            case NORTH: {
                rot = null;
                break;
            }
            case SOUTH: {
                rot = ModelRotation.X0_Y180;
                break;
            }
            case WEST: {
                rot = ModelRotation.X0_Y270;
                break;
            }
            default: {
                return null;
            }
        }
        if ((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0) {
            return PaintRegistry.getModel(IBakedModel.class, "pressure_plate_down", paint, (IModelState)rot);
        }
        return PaintRegistry.getModel(IBakedModel.class, "pressure_plate_up", paint, (IModelState)rot);
    }

    protected EnumFacing getRotation(IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getRotation();
        }
        return EnumFacing.NORTH;
    }

    protected void setRotation(IBlockAccess world, BlockPos pos, EnumFacing rotation) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setRotation(rotation);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(Block block, ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "pressure_plate_inventory", paintSource, null);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        if (paintSource != this.defaultPaints[EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal()]) {
            IBlockState stdOverlay = BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
            IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "pressure_plate_inventory", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION);
            list.add(model2);
        }
        return list;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.WOOD == ((TilePaintedPressurePlate)te).getType() ? 20 : 0;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.WOOD == ((TilePaintedPressurePlate)te).getType() ? 5 : 0;
        }
        return 0;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumPressurePlateType type : EnumPressurePlateType.values()) {
            if (tab == EnderIOTab.tabNoTab || type.ordinal() >= EnumPressurePlateType.DARKSTEEL.ordinal()) {
                list.add(new ItemStack(itemIn, 1, EnumPressurePlateType.getMetaFromType(type, false)));
            }
            list.add(new ItemStack(itemIn, 1, EnumPressurePlateType.getMetaFromType(type, true)));
        }
    }

    protected void func_180666_a(World worldIn, BlockPos pos, IBlockState state, int oldRedstoneStrength) {
        boolean isOn;
        int newRedstoneStrength = this.func_180669_e(worldIn, pos);
        boolean wasOn = oldRedstoneStrength > 0;
        boolean bl = isOn = newRedstoneStrength > 0;
        if (oldRedstoneStrength != newRedstoneStrength) {
            state = this.func_176575_a(state, newRedstoneStrength);
            worldIn.func_180501_a(pos, state, 2);
            this.func_176578_d(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
            if (!this.isSilent((IBlockAccess)worldIn, pos)) {
                if (!isOn && wasOn) {
                    worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
                } else if (isOn && !wasOn) {
                    worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.6f, false);
                }
            }
        }
        if (isOn) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "." + EnumPressurePlateType.getTypeFromMeta(meta).func_176610_l() + (EnumPressurePlateType.getSilentFromMeta(meta) ? ".silent" : "");
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.getUnlocalizedName(itemStack.func_77960_j());
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack drop = this.getDrop((IBlockAccess)world, new BlockPos(x, y, z));
        if (drop != null) {
            tooltip.add(PainterUtil2.getTooltTipText(drop));
            CapturedMob capturedMob = CapturedMob.create(drop);
            if (capturedMob != null) {
                tooltip.add(EnderIO.lang.localize("tile.plockPaintedPressurePlate.tuned", new Object[]{capturedMob.getDisplayName()}));
            }
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (PainterUtil2.canRenderInLayer(paintSource, blockLayer) && (paintSource == null || paintSource.func_177230_c() != EnderIO.blockFusedQuartz)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource, this.getRotation(world, pos)), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }

    protected void func_185507_b(World worldIn, BlockPos color) {
        if (this.field_149764_J == Material.field_151575_d) {
            worldIn.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else {
            worldIn.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void func_185508_c(World worldIn, BlockPos pos) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    public static class BlockItemPaintedPressurePlate
    extends BlockItemPaintedBlock {
        public BlockItemPaintedPressurePlate(BlockPaintedPressurePlate block, String name) {
            super((Block)block, name);
        }

        public boolean func_77636_d(ItemStack stack) {
            return EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()) == EnumPressurePlateType.TUNED;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            super.func_77624_a(stack, playerIn, tooltip, advanced);
            CapturedMob capturedMob = CapturedMob.create(stack);
            if (capturedMob != null) {
                tooltip.add(EnderIO.lang.localize("tile.plockPaintedPressurePlate.tuned", new Object[]{capturedMob.getDisplayName()}));
            }
        }
    }

    @Storable
    public static class TilePaintedPressurePlate
    extends TileEntityPaintedBlock {
        @Store
        private EnumPressurePlateType type = EnumPressurePlateType.WOOD;
        @Store
        private boolean silent = false;
        @Store
        private EnumFacing rotation = EnumFacing.NORTH;
        @Store
        private CapturedMob capturedMob = null;

        protected EnumPressurePlateType getType() {
            return this.type;
        }

        protected void setType(EnumPressurePlateType type) {
            this.type = type;
            this.func_70296_d();
        }

        protected boolean isSilent() {
            return this.silent;
        }

        protected void setSilent(boolean silent) {
            this.silent = silent;
            this.func_70296_d();
        }

        protected EnumFacing getRotation() {
            return this.rotation;
        }

        protected void setRotation(EnumFacing rotation) {
            if (rotation != EnumFacing.DOWN && rotation != EnumFacing.UP) {
                this.rotation = rotation;
                this.func_70296_d();
                this.updateBlock();
            }
        }

        protected CapturedMob getMobType() {
            return this.capturedMob;
        }

        protected void setMobType(CapturedMob capturedMob) {
            this.capturedMob = capturedMob;
        }
    }
}

