/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.recipe;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.painter.recipe.AbstractPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.util.NullHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BasicPainterTemplate<T extends Block>
extends AbstractPainterTemplate<T> {
    protected final T resultBlock;
    protected final Block[] validTargets;
    protected final boolean allowEasyConversion;

    public BasicPainterTemplate(boolean allowEasyConversion, T resultBlock, Block ... validTargetBlocks) {
        this.resultBlock = resultBlock;
        this.validTargets = validTargetBlocks;
        this.allowEasyConversion = allowEasyConversion;
    }

    public BasicPainterTemplate(T resultBlock, Block ... validTargetBlocks) {
        this(true, resultBlock, validTargetBlocks);
    }

    @Override
    public boolean isRecipe(ItemStack paintSource, ItemStack target) {
        return paintSource != null && this.isValidTarget(target) && PainterUtil2.isValid(paintSource, this.getTargetBlock(target));
    }

    @Override
    public boolean isPartialRecipe(ItemStack paintSource, ItemStack target) {
        if (paintSource == null) {
            return this.isValidTarget(target);
        }
        if (target == null) {
            return PainterUtil2.isValid(paintSource, this.getTargetBlock(null));
        }
        return this.isValidTarget(target) && PainterUtil2.isValid(paintSource, this.getTargetBlock(target));
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(ItemStack paintSource, ItemStack target) {
        T targetBlock = this.getTargetBlock(target);
        if (target == null || paintSource == null || targetBlock == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        Block paintBlock = PainterUtil2.getBlockFromItem(paintSource);
        if (paintBlock == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        IBlockState paintState = PainterUtil2.Block$getBlockFromItem_stack$getItem___$getStateFromMeta_stack$getMetadata___(paintSource, paintBlock);
        if (paintState == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack result = this.isUnpaintingOp(paintSource, target);
        if (result == null) {
            result = this.mkItemStack(target, (Block)targetBlock);
            if (targetBlock == Block.func_149634_a((Item)target.func_77973_b()) && target.func_77942_o()) {
                result.func_77982_d(NullHelper.notnullM(target.func_77978_p(), "ItemStack.getTagCompound() after .hasTagCompound()").func_74737_b());
            }
            ((IPaintable)targetBlock).setPaintSource((Block)targetBlock, result, paintState);
        } else if (result.func_77973_b() == target.func_77973_b() && target.func_77942_o()) {
            result.func_77982_d(NullHelper.notnullM(target.func_77978_p(), "ItemStack.getTagCompound() after .hasTagCompound()").func_74737_b());
            Block realresult = PainterUtil2.getBlockFromItem(result);
            if (realresult instanceof IPaintable) {
                ((IPaintable)realresult).setPaintSource(realresult, result, null);
            } else {
                PainterUtil2.setSourceBlock(result, null);
            }
        }
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(result)};
    }

    @Nonnull
    protected ItemStack mkItemStack(@Nonnull ItemStack target, @Nonnull Block targetBlock) {
        Item itemFromBlock = Item.func_150898_a((Block)targetBlock);
        if (itemFromBlock == null || itemFromBlock.func_77645_m() || itemFromBlock.func_77614_k()) {
            return new ItemStack(targetBlock, 1, target.func_77952_i());
        }
        return new ItemStack(targetBlock, 1, 0);
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null) {
            return false;
        }
        if (input.slotNumber == 0) {
            return this.isValidTarget(input.item);
        }
        if (input.slotNumber == 1) {
            return PainterUtil2.isValid(input.item, this.resultBlock);
        }
        return false;
    }

    protected T getTargetBlock(ItemStack target) {
        return this.resultBlock;
    }

    public ItemStack isUnpaintingOp(ItemStack paintSource, ItemStack target) {
        if (paintSource == null || target == null) {
            return null;
        }
        Block paintBlock = PainterUtil2.getBlockFromItem(paintSource);
        Block targetBlock = Block.func_149634_a((Item)target.func_77973_b());
        if (paintBlock == null || targetBlock == null) {
            return null;
        }
        if (paintBlock == this.resultBlock) {
            return this.mkItemStack(target, targetBlock);
        }
        if (paintBlock == targetBlock && this.allowEasyConversion) {
            return this.mkItemStack(paintSource, targetBlock);
        }
        if (targetBlock == this.resultBlock && this.allowEasyConversion) {
            for (Block validTarget : this.validTargets) {
                if (paintBlock != validTarget) continue;
                return this.mkItemStack(paintSource, paintBlock);
            }
        }
        return null;
    }

    @Override
    public boolean isValidTarget(ItemStack target) {
        if (target == null) {
            return false;
        }
        Block blk = Block.func_149634_a((Item)target.func_77973_b());
        if (blk == this.resultBlock) {
            return true;
        }
        for (int i = 0; i < this.validTargets.length; ++i) {
            if (this.validTargets[i] != blk) continue;
            return true;
        }
        return false;
    }
}

