/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import com.enderio.core.common.util.Util;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.BasicManyToOneRecipe;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.IManyToOneRecipe;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ManyToOneRecipeManager {
    private final List<IManyToOneRecipe> recipes = new ArrayList<IManyToOneRecipe>();
    private final String coreFileName;
    private final String customFileName;
    private final String managerName;

    public ManyToOneRecipeManager(String coreFileName, String custonFileName, String managerName) {
        this.coreFileName = coreFileName;
        this.customFileName = custonFileName;
        this.managerName = managerName;
    }

    public void loadRecipesFromConfig() {
        CustomTagHandler tagHandler = this.createCustomTagHandler();
        RecipeConfig config = RecipeConfig.loadRecipeConfig(this.coreFileName, this.customFileName, tagHandler);
        if (config != null) {
            this.processConfig(config);
            if (tagHandler != null) {
                tagHandler.configProcessed();
            }
        } else {
            Log.error("Could not load recipes for " + this.managerName + ".");
        }
    }

    protected CustomTagHandler createCustomTagHandler() {
        return null;
    }

    public void addCustomRecipes(String xmlDef) {
        RecipeConfig config;
        CustomTagHandler tagHandler = this.createCustomTagHandler();
        try {
            config = RecipeConfigParser.parse(xmlDef, tagHandler);
        }
        catch (Exception e) {
            Log.error("Error parsing custom xml for " + this.managerName);
            return;
        }
        if (config == null) {
            Log.error("Could not process custom XML " + this.managerName);
            return;
        }
        this.processConfig(config);
        if (tagHandler != null) {
            tagHandler.configProcessed();
        }
    }

    public List<IManyToOneRecipe> getRecipes() {
        return this.recipes;
    }

    private void processConfig(RecipeConfig config) {
        if (config.isDumpItemRegistery()) {
            Util.dumpModObjects((File)new File(Config.configDirectory, "modObjectsRegistery.txt"));
        }
        if (config.isDumpOreDictionary()) {
            Util.dumpOreNames((File)new File(Config.configDirectory, "oreDictionaryRegistery.txt"));
        }
        List<Recipe> newRecipes = config.getRecipes(false);
        Log.info("Found " + newRecipes.size() + " valid " + this.managerName + " recipes in config.");
        for (Recipe rec : newRecipes) {
            if (Config.createSyntheticRecipes && rec.getInputs().length == 1 && !rec.getInputs()[0].isFluid() && rec.getInputs()[0].getInput().field_77994_a <= 21 && rec.getOutputs().length == 1 && !rec.getOutputs()[0].isFluid() && rec.getOutputs()[0].getOutput().field_77994_a <= 21) {
                IRecipe dupe = this.getRecipeForInputs(rec.getInputStacks());
                if (dupe != null) {
                    Log.warn("The supplied recipe " + rec + " for " + this.managerName + " may be a duplicate to: " + dupe);
                }
                int er = rec.getEnergyRequired();
                RecipeBonusType bns = rec.getBonusType();
                RecipeOutput out = rec.getOutputs()[0];
                RecipeInput in = rec.getInputs()[0];
                RecipeInput in2 = in.copy();
                in2.getInput().field_77994_a *= 2;
                RecipeOutput out2 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
                out2.getOutput().field_77994_a *= 2;
                RecipeInput in3 = in.copy();
                in3.getInput().field_77994_a *= 3;
                RecipeOutput out3 = new RecipeOutput(out.getOutput(), out.getChance(), out.getExperiance());
                out3.getOutput().field_77994_a *= 3;
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in.copy(), in.copy(), in.copy())));
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in.copy(), in2.copy())));
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in2.copy(), in.copy())));
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, in.copy(), in.copy())));
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out3, er * 3, bns, in3.copy())));
                this.recipes.add(new BasicManyToOneRecipe(new Recipe(out2, er * 2, bns, in2.copy())));
                this.recipes.add(new BasicManyToOneRecipe(rec));
                Log.info("Created 6 synthetic recipes for " + in.getInput() + " => " + out.getOutput());
                continue;
            }
            this.addRecipe(new BasicManyToOneRecipe(rec));
        }
        Log.info("Finished processing " + this.managerName + " recipes. " + this.recipes.size() + " recipes avaliable.");
    }

    public void addRecipe(IManyToOneRecipe recipe) {
        if (recipe == null) {
            Log.debug("Could not add invalid recipe: " + recipe + " for " + this.managerName);
            return;
        }
        IRecipe rec = this.getRecipeForInputs(recipe.getInputStacks());
        if (rec != null) {
            Log.warn("The supplied recipe " + recipe + " for " + this.managerName + " may be a duplicate to: " + rec);
        }
        this.recipes.add(recipe);
    }

    private IRecipe getRecipeForInputs(List<ItemStack> inputs) {
        MachineRecipeInput[] ins = new MachineRecipeInput[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            ins[i] = new MachineRecipeInput(-1, inputs.get(i));
        }
        return this.getRecipeForInputs(ins);
    }

    public IRecipe getRecipeForInputs(MachineRecipeInput[] inputs) {
        for (IManyToOneRecipe rec : this.recipes) {
            if (!rec.isInputForRecipe(inputs)) continue;
            return rec;
        }
        return null;
    }

    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null || input.item == null) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            for (RecipeInput ri : recipe.getInputs()) {
                if (!ri.isInput(input.item) || ri.getSlotNumber() != -1 && input.slotNumber != ri.getSlotNumber()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidRecipeComponents(ItemStack[] inputs) {
        if (inputs == null || inputs.length == 0) {
            return false;
        }
        for (IManyToOneRecipe recipe : this.recipes) {
            if (!recipe.isValidRecipeComponents(inputs)) continue;
            return true;
        }
        return false;
    }

    public float getExperianceForOutput(ItemStack output) {
        for (IManyToOneRecipe recipe : this.recipes) {
            if (recipe.getOutput().func_77973_b() != output.func_77973_b() || recipe.getOutput().func_77952_i() != output.func_77952_i()) continue;
            return recipe.getOutputs()[0].getExperiance();
        }
        return 0.0f;
    }
}

