/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.GuiPoweredSpawner;
import crazypants.enderio.machine.spawner.PacketMode;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.util.CapturedMob;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPoweredSpawner
extends AbstractMachineBlock<TilePoweredSpawner>
implements IAdvancedTooltipProvider,
IPaintable.INonSolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static final String KEY_SPAWNED_BY_POWERED_SPAWNER = "spawnedByPoweredSpawner";
    private final List<ResourceLocation> toolBlackList = new ArrayList<ResourceLocation>();
    private Field fieldpersistenceRequired;
    private Method getEntNameMethod;
    private Field spawnDelayField;
    private final Map<BlockCoord, ItemStack> dropCache = new HashMap<BlockCoord, ItemStack>();

    public static BlockPoweredSpawner create() {
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPoweredSpawner.getUnlocalisedName(), new DummyRecipe());
        PacketHandler.INSTANCE.registerMessage(PacketMode.class, PacketMode.class, PacketHandler.nextID(), Side.SERVER);
        PoweredSpawnerConfig.getInstance();
        BlockPoweredSpawner res = new BlockPoweredSpawner();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockPoweredSpawner() {
        super(ModObject.blockPoweredSpawner, TilePoweredSpawner.class);
        String[] blackListNames;
        for (String blackListName : blackListNames = Config.brokenSpawnerToolBlacklist) {
            this.toolBlackList.add(new ResourceLocation(blackListName));
        }
        try {
            this.fieldpersistenceRequired = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"field_82179_bU", "persistenceRequired"});
        }
        catch (Exception e) {
            Log.error("BlockPoweredSpawner: Could not find field: persistenceRequired");
        }
        try {
            this.getEntNameMethod = ReflectionHelper.findMethod(MobSpawnerBaseLogic.class, null, (String[])new String[]{"getEntityNameToSpawn", "func_98276_e"}, (Class[])new Class[0]);
        }
        catch (Exception e) {
            Log.error("BlockPoweredSpawner: Could not find field: mobID");
        }
        try {
            this.spawnDelayField = ReflectionHelper.findField(MobSpawnerBaseLogic.class, (String[])new String[]{"spawnDelay", "field_98286_b"});
        }
        catch (Exception e) {
            Log.error("BlockPoweredSpawner: Could not find field: spawnDelay");
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent evt) {
        if (evt.getState().func_177230_c() instanceof BlockMobSpawner) {
            if (!(evt.getPlayer() == null || evt.getPlayer().field_71075_bZ.field_75098_d || evt.getPlayer().field_70170_p.field_72995_K || evt.isCanceled())) {
                TileEntity tile = evt.getPlayer().field_70170_p.func_175625_s(evt.getPos());
                if (tile instanceof TileEntityMobSpawner) {
                    String entityName;
                    TileEntityMobSpawner spawner;
                    MobSpawnerBaseLogic logic;
                    if (Math.random() > Config.brokenSpawnerDropChance) {
                        return;
                    }
                    ItemStack equipped = evt.getPlayer().func_184614_ca();
                    if (equipped != null) {
                        for (ResourceLocation uid : this.toolBlackList) {
                            Item blackListItem = (Item)Item.field_150901_e.func_82594_a((Object)uid);
                            if (blackListItem != equipped.func_77973_b()) continue;
                            return;
                        }
                    }
                    if ((logic = (spawner = (TileEntityMobSpawner)tile).func_145881_a()) != null && (entityName = this.getEntityName(logic)) != null && !this.isBlackListed(entityName)) {
                        SkeletonType type = null;
                        if ("Skeleton".equals(entityName)) {
                            type = SkeletonType.NORMAL;
                            Biome biome = tile.func_145831_w().getBiomeForCoordsBody(tile.func_174877_v());
                            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                                type = SkeletonType.WITHER;
                            } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && Math.random() > 0.2) {
                                type = SkeletonType.STRAY;
                            }
                        }
                        ItemStack drop = CapturedMob.create(entityName, type).toStack(EnderIO.itemBrokenSpawner, 0, 1);
                        this.dropCache.put(new BlockCoord(evt.getPos()), drop);
                        for (int i = (int)(Math.random() * 7.0); i > 0; --i) {
                            this.setSpawnDelay(logic);
                            logic.func_98278_g();
                        }
                    }
                }
            } else {
                this.dropCache.put(new BlockCoord(evt.getPos()), null);
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent evt) {
        if (!evt.isCanceled() && evt.getState().func_177230_c() instanceof BlockMobSpawner) {
            BlockCoord bc = new BlockCoord(evt.getPos());
            if (this.dropCache.containsKey(bc)) {
                ItemStack stack = this.dropCache.get(bc);
                if (stack != null) {
                    evt.getDrops().add(stack);
                }
            } else {
                try {
                    for (Object object : evt.getWorld().field_147482_g) {
                        String entityName;
                        MobSpawnerBaseLogic logic;
                        if (!(object instanceof TileEntityMobSpawner)) continue;
                        TileEntityMobSpawner spawner = (TileEntityMobSpawner)object;
                        BlockPos p = spawner.func_174877_v();
                        if (spawner.func_145831_w() != evt.getWorld() || !p.equals((Object)evt.getPos()) || (logic = spawner.func_145881_a()) == null || (entityName = this.getEntityName(logic)) == null || this.isBlackListed(entityName)) continue;
                        evt.getDrops().add(CapturedMob.create(entityName, null).toStack(EnderIO.itemBrokenSpawner, 0, 1));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String getEntityName(MobSpawnerBaseLogic logic) {
        if (this.getEntNameMethod != null) {
            try {
                return (String)this.getEntNameMethod.invoke((Object)logic, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void setSpawnDelay(MobSpawnerBaseLogic logic) {
        if (this.spawnDelayField != null) {
            try {
                this.spawnDelayField.set(logic, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.dropCache.clear();
        }
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.getLeft() == null || evt.getLeft().field_77994_a != 1 || evt.getLeft().func_77973_b() != Item.func_150898_a((Block)EnderIO.blockPoweredSpawner)) {
            return;
        }
        if (evt.getRight() == null || evt.getRight().field_77994_a != 1 || evt.getRight().func_77973_b() != EnderIO.itemBrokenSpawner) {
            return;
        }
        CapturedMob spawnerType = CapturedMob.create(evt.getRight());
        if (spawnerType == null || this.isBlackListed(spawnerType.getEntityName())) {
            return;
        }
        evt.setCost(Config.powerSpawnerAddSpawnerCost);
        evt.setOutput(evt.getLeft().func_77946_l());
        if (evt.getOutput().func_77978_p() == null) {
            evt.getOutput().func_77982_d(new NBTTagCompound());
        }
        evt.getOutput().func_77978_p().func_74757_a("eio.abstractMachine", true);
        spawnerType.toNbt(evt.getOutput().func_77978_p());
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent livingUpdate) {
        EntityLivingBase ent = livingUpdate.getEntityLiving();
        if (!ent.getEntityData().func_74764_b(KEY_SPAWNED_BY_POWERED_SPAWNER)) {
            return;
        }
        if (this.fieldpersistenceRequired == null) {
            ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            return;
        }
        long spawnTime = ent.getEntityData().func_74763_f(KEY_SPAWNED_BY_POWERED_SPAWNER);
        long livedFor = livingUpdate.getEntity().field_70170_p.func_82737_E() - spawnTime;
        if (livedFor > (long)(Config.poweredSpawnerDespawnTimeSeconds * 20)) {
            try {
                this.fieldpersistenceRequired.setBoolean(livingUpdate.getEntityLiving(), false);
                ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
            catch (Exception e) {
                Log.warn("BlockPoweredSpawner.onLivingUpdate: Error occured allowing entity to despawn: " + e);
                ent.getEntityData().func_82580_o(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
        }
    }

    public boolean isBlackListed(String entityId) {
        return PoweredSpawnerConfig.getInstance().isBlackListed(entityId);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TilePoweredSpawner) {
            return new ContainerPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TilePoweredSpawner) {
            return new GuiPoweredSpawner(player.field_71071_by, (TilePoweredSpawner)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 88;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        CapturedMob mob = CapturedMob.create(itemstack);
        if (mob != null) {
            list.add(mob.getDisplayName());
        } else {
            list.add(EnderIO.lang.localizeExact("tile.blockPoweredSpawner.tooltip.empty"));
        }
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        if (CapturedMob.containsSoul(itemstack)) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.blockPoweredSpawner");
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"tile.blockPoweredSpawner.empty");
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        CapturedMob capturedMob;
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof TilePoweredSpawner && (capturedMob = ((TilePoweredSpawner)tileEntity).getEntity()) != null) {
            tooltip.add(capturedMob.getDisplayName());
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_149666_a(item, tab, list);
        list.add(CapturedMob.create("Enderman", null).toStack(item, 0, 1));
        list.add(CapturedMob.create("Chicken", null).toStack(item, 0, 1));
        list.add(CapturedMob.create("Skeleton", SkeletonType.NORMAL).toStack(item, 0, 1));
        list.add(CapturedMob.create("Skeleton", SkeletonType.WITHER).toStack(item, 0, 1));
        list.add(CapturedMob.create("Skeleton", SkeletonType.STRAY).toStack(item, 0, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.FRONT_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TilePoweredSpawner tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

